#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.12.1
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.12.1-6E4AKCzHUHULkfFmJnvyog-haskell-ci-internal

key:
    haskell-ci-0.12.1-6E4AKCzHUHULkfFmJnvyog-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  d737b39afccb0bab9899ccdeb0878d9a
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cli HaskellCI.Compiler
    HaskellCI.Config HaskellCI.Config.ConstraintSet
    HaskellCI.Config.CopyFields HaskellCI.Config.Docspec
    HaskellCI.Config.Doctest HaskellCI.Config.Dump
    HaskellCI.Config.Folds HaskellCI.Config.HLint
    HaskellCI.Config.Installed HaskellCI.Config.Jobs
    HaskellCI.Config.PackageScope HaskellCI.Config.Ubuntu
    HaskellCI.Config.Validity HaskellCI.Diagnostics HaskellCI.Error
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.0.2/site-local/haskell-ci-0.12.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/haskell-ci-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.12.1-6E4AKCzHUHULkfFmJnvyog-haskell-ci-internal

depends:
    Cabal-3.4.1.0 HsYAML-0.2.1.1-BiJ23eMT6HaIRDOYk23PIR
    ShellCheck-0.8.0-1JOe8onn60A15Yyj9DGfJj
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu
    base16-bytestring-1.0.2.0-JAhsVwuAYUHf0LicTQmUd binary-0.8.8.0
    bytestring-0.10.12.1
    cabal-install-parsers-0.4.2-1VyaAA6ES3cKugfyG2984D
    containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-8ZeO4nK1S0cB7jsEy9ybtK deepseq-1.4.5.0
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.1
    generic-lens-lite-0.1-5glJveGIXPk7sgczrz8qf2
    indexed-traversable-0.1.2-55rCITp0bj2K4TSTU28RrG
    indexed-traversable-instances-0.1.1.1-FBkYLpT4LalDTz44MwmQjh
    ini-0.4.2-Hps9s6tKH9H6mrQ3OI2dwF
    lattices-2.0.3-v5U1h2GQe2G7JTFTrFSDy mtl-2.2.2
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    optparse-applicative-0.17.0.0-5RAB8jXJau3LDHQVpRHOkD
    parsec-3.1.14.0 pretty-1.1.3.6 process-1.6.13.2
    temporary-1.3-HXIdO020OG29nAlGx7vsUT text-1.2.5.0
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    zinza-0.2-3JN3VQdFPbdkDqAMU2hYV

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

