/**
 * TelemetryContext.ts
 * @copyright Microsoft 2018
 */
import { ITelemetryItem, IProcessTelemetryContext, IAppInsightsCore, IDistributedTraceContext } from "@microsoft/applicationinsights-core-js";
import { _SessionManager } from "./Context/Session";
import { IOperatingSystem, ITelemetryTrace, IWeb, IApplication, IDevice, ILocation, IUserContext, IInternal, ISession } from "@microsoft/applicationinsights-common";
import { ITelemetryConfig } from "./Interfaces/ITelemetryConfig";
import { IPropTelemetryContext } from "./Interfaces/IPropTelemetryContext";
export declare class TelemetryContext implements IPropTelemetryContext {
    application: IApplication;
    device: IDevice;
    location: ILocation;
    telemetryTrace: ITelemetryTrace;
    user: IUserContext;
    internal: IInternal;
    session: ISession;
    sessionManager: _SessionManager;
    os: IOperatingSystem;
    web: IWeb;
    appId: () => string;
    getSessionId: () => string;
    constructor(core: IAppInsightsCore, defaultConfig: ITelemetryConfig, previousTraceCtx?: IDistributedTraceContext);
    applySessionContext(evt: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    applyOperatingSystemContxt(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    applyApplicationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    applyDeviceContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    applyInternalContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    applyLocationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    applyOperationContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    applyWebContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    applyUserContext(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    cleanUp(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
}
