/**
 * PropertiesPlugin.ts
 * @copyright Microsoft 2018
 */
import { BaseTelemetryPlugin, IConfiguration, IAppInsightsCore, IPlugin, ITelemetryItem, IProcessTelemetryContext, ITelemetryPluginChain } from "@microsoft/applicationinsights-core-js";
import { IConfig, IPropertiesPlugin } from "@microsoft/applicationinsights-common";
import { ITelemetryConfig } from "./Interfaces/ITelemetryConfig";
import { IPropTelemetryContext } from "./Interfaces/IPropTelemetryContext";
export default class PropertiesPlugin extends BaseTelemetryPlugin implements IPropertiesPlugin {
    static getDefaultConfig(): ITelemetryConfig;
    context: IPropTelemetryContext;
    priority: number;
    identifier: string;
    constructor();
    initialize(config: IConfiguration & IConfig, core: IAppInsightsCore, extensions: IPlugin[], pluginChain?: ITelemetryPluginChain): void;
    /**
     * Add Part A fields to the event
     * @param event The event that needs to be processed
     */
    processTelemetry(event: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
}
