import { ITelemetryConfig } from "../Interfaces/ITelemetryConfig";
import { IUserContext } from "@microsoft/applicationinsights-common";
import { IAppInsightsCore } from "@microsoft/applicationinsights-core-js";
export declare class User implements IUserContext {
    static cookieSeparator: string;
    static userCookieName: string;
    static authUserCookieName: string;
    /**
     * The telemetry configuration.
     */
    config: ITelemetryConfig;
    /**
     * The user ID.
     */
    id: string;
    /**
     * Authenticated user id
     */
    authenticatedId: string;
    /**
     * The localId
     */
    localId: string;
    /**
     * The account ID.
     */
    accountId: string;
    /**
     * The account acquisition date.
     */
    accountAcquisitionDate: string;
    /**
     * A flag indicating whether this represents a new user
     */
    isNewUser: boolean;
    /**
     * A flag indicating whether the user cookie has been set
     */
    isUserCookieSet: boolean;
    constructor(config: ITelemetryConfig, core: IAppInsightsCore);
    /**
    * Sets the authenticated user id and the account id in this session.
    *
    * @param authenticatedUserId {string} - The authenticated user id. A unique and persistent string that represents each authenticated user in the service.
    * @param accountId {string} - An optional string to represent the account associated with the authenticated user.
    */
    setAuthenticatedUserContext(authenticatedUserId: string, accountId?: string, storeInCookie?: boolean): void;
    /**
     * Clears the authenticated user id and the account id from the user context.
     * @returns {}
     */
    clearAuthenticatedUserContext(): void;
    /**
     * Update or create the user cookie if cookies where previously disabled or the new userId does not match the existing value.
     * If you pass nothing a new random user id will be created.
     * @param userId - Specific either the current (via appInsights.context.user.id) or new id that you want to set
     */
    update(userId?: string): void;
}
