import { ISession } from "@microsoft/applicationinsights-common";
import { IAppInsightsCore } from "@microsoft/applicationinsights-core-js";
export interface ISessionConfig {
    sessionRenewalMs?: () => number;
    sessionExpirationMs?: () => number;
    namePrefix?: () => string;
    sessionCookiePostfix?: () => string;
    idLength?: () => number;
    getNewId?: () => (idLength?: number) => string;
    /**
     * @deprecated Avoid using this value to override the cookie manager cookie domain.
     */
    cookieDomain?: () => string;
}
export declare class Session implements ISession {
    /**
     * The session ID.
     */
    id?: string;
    /**
     * The date at which this guid was generated.
     * Per the spec the ID will be regenerated if more than acquisitionSpan milliseconds elapsed from this time.
     */
    acquisitionDate?: number;
    /**
     * The date at which this session ID was last reported.
     * This value should be updated whenever telemetry is sent using this ID.
     * Per the spec the ID will be regenerated if more than renewalSpan milliseconds elapse from this time with no activity.
     */
    renewalDate?: number;
}
export declare class _SessionManager {
    static acquisitionSpan: number;
    static renewalSpan: number;
    static cookieUpdateInterval: number;
    automaticSession: Session;
    config: ISessionConfig;
    constructor(config: ISessionConfig, core?: IAppInsightsCore);
    update(): void;
    /**
     *  Record the current state of the automatic session and store it in our cookie string format
     *  into the browser's local storage. This is used to restore the session data when the cookie
     *  expires.
     */
    backup(): void;
}
