import { IDependencyTelemetry } from "@microsoft/applicationinsights-common";
import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
export interface IAjaxRecordResponse {
    statusText: string;
    headerMap: Object;
    correlationContext: string;
    type?: string;
    responseText?: string;
    response?: Object;
}
export declare class XHRMonitoringState {
    openDone: boolean;
    setRequestHeaderDone: boolean;
    sendDone: boolean;
    abortDone: boolean;
    stateChangeAttached: boolean;
    constructor();
}
export declare class ajaxRecord {
    completed: boolean;
    requestHeadersSize: number;
    requestHeaders: any;
    responseReceivingDuration: number;
    callbackDuration: number;
    ajaxTotalDuration: number;
    aborted: number;
    pageUrl: string;
    requestUrl: string;
    requestSize: number;
    method: string;
    perfMark: PerformanceMark;
    perfTiming: PerformanceResourceTiming;
    perfAttempts?: number;
    async?: boolean;
    errorStatusText?: boolean;
    status: string | number;
    requestSentTime: number;
    responseStartedTime: number;
    responseFinishedTime: number;
    callbackFinishedTime: number;
    endTime: number;
    xhrMonitoringState: XHRMonitoringState;
    clientFailure: number;
    traceID: string;
    spanID: string;
    traceFlags?: number;
    constructor(traceID: string, spanID: string, logger: IDiagnosticLogger);
    getAbsoluteUrl(): string;
    getPathName(): string;
    CreateTrackItem(ajaxType: string, enableRequestHeaderTracking: boolean, getResponse: () => IAjaxRecordResponse): IDependencyTelemetry;
}
