/*
 * Microsoft Application Insights XHR dependencies plugin, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 *
 * Microsoft Application Insights Team
 * https://github.com/microsoft/ApplicationInsights-JS#readme
 */

declare namespace ApplicationInsights {
    import { BaseTelemetryPlugin } from '@microsoft/applicationinsights-core-js';
    import { IAppInsightsCore } from '@microsoft/applicationinsights-core-js';
    import { IConfig } from '@microsoft/applicationinsights-common';
    import { IConfiguration } from '@microsoft/applicationinsights-core-js';
    import { ICorrelationConfig } from '@microsoft/applicationinsights-common';
    import { IDependencyTelemetry } from '@microsoft/applicationinsights-common';
    import { IDiagnosticLogger } from '@microsoft/applicationinsights-core-js';
    import { IPlugin } from '@microsoft/applicationinsights-core-js';
    import { IProcessTelemetryContext } from '@microsoft/applicationinsights-core-js';
    import { ITelemetryItem } from '@microsoft/applicationinsights-core-js';
    import { ITelemetryPluginChain } from '@microsoft/applicationinsights-core-js';

    class AjaxPlugin extends BaseTelemetryPlugin implements IDependenciesPlugin, IInstrumentationRequirements {
        static identifier: string;
        static getDefaultConfig(): ICorrelationConfig;
        static getEmptyConfig(): ICorrelationConfig;
        identifier: string;
        priority: number;
        constructor();
        initialize(config: IConfiguration & IConfig, core: IAppInsightsCore, extensions: IPlugin[], pluginChain?: ITelemetryPluginChain): void;
        processTelemetry(item: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
        /**
         * Logs dependency call
         * @param dependencyData dependency data object
         */
        trackDependencyData(dependency: IDependencyTelemetry, properties?: {
            [key: string]: any;
        }): void;
        includeCorrelationHeaders(ajaxData: ajaxRecord, input?: Request | string, init?: RequestInit, xhr?: XMLHttpRequestInstrumented): any;
        /**
         * Add an ajax listener which is called just prior to the request being sent and before the correlation headers are added, to allow you
         * to access the headers and modify the values used to generate the distributed tracing correlation headers.
         * @param dependencyListener - The Telemetry Initializer function
         * @returns - A IDependencyListenerHandler to enable the initializer to be removed
         */
        addDependencyListener(dependencyListener: DependencyListenerFunction): IDependencyListenerHandler;
        /**
         * Protected function to allow sub classes the chance to add additional properties to the dependency event
         * before it's sent. This function calls track, so sub-classes must call this function after they have
         * populated their properties.
         * @param dependencyData dependency data object
         */
        protected trackDependencyDataInternal(dependency: IDependencyTelemetry, properties?: {
            [key: string]: any;
        }, systemProperties?: {
            [key: string]: any;
        }): void;
    }

    class ajaxRecord {
        completed: boolean;
        requestHeadersSize: number;
        requestHeaders: any;
        responseReceivingDuration: number;
        callbackDuration: number;
        ajaxTotalDuration: number;
        aborted: number;
        pageUrl: string;
        requestUrl: string;
        requestSize: number;
        method: string;
        perfMark: PerformanceMark;
        perfTiming: PerformanceResourceTiming;
        perfAttempts?: number;
        async?: boolean;
        errorStatusText?: boolean;
        status: string | number;
        requestSentTime: number;
        responseStartedTime: number;
        responseFinishedTime: number;
        callbackFinishedTime: number;
        endTime: number;
        xhrMonitoringState: XHRMonitoringState;
        clientFailure: number;
        traceID: string;
        spanID: string;
        traceFlags?: number;
        constructor(traceID: string, spanID: string, logger: IDiagnosticLogger);
        getAbsoluteUrl(): string;
        getPathName(): string;
        CreateTrackItem(ajaxType: string, enableRequestHeaderTracking: boolean, getResponse: () => IAjaxRecordResponse): IDependencyTelemetry;
    }

    type DependencyListenerFunction = (dependencyDetails: IDependencyListenerDetails) => void;

    interface IAjaxRecordResponse {
        statusText: string;
        headerMap: Object;
        correlationContext: string;
        type?: string;
        responseText?: string;
        response?: Object;
    }

    interface IDependenciesPlugin extends IDependencyListenerContainer {
        /**
         * Logs dependency call
         * @param dependencyData dependency data object
         */
        trackDependencyData(dependency: IDependencyTelemetry): void;
    }

    interface IDependencyListenerContainer {
        /**
         * Add an ajax listener which is called just prior to the request being sent and before the correlation headers are added, to allow you
         * to access the headers and modify the values used to generate the distributed tracing correlation headers. (added in v2.8.4)
         * @param dependencyListener - The Telemetry Initializer function
         * @returns - A IDependencyListenerHandler to enable the initializer to be removed
         */
        addDependencyListener(dependencyListener: DependencyListenerFunction): IDependencyListenerHandler;
    }

    interface IDependencyListenerDetails {
        /**
         * The current core instance
         */
        core: IAppInsightsCore;
        /**
         * Provided only if the dependency request is an XHR call
         */
        xhr?: XMLHttpRequest;
        /**
         * Provided only if the dependency request is a fetch call, this is the input argument being used,
         * re-assigning this value has not affect on the value used for the request, however, when this is a Request
         * object changing the value of the Request will be used for the outbound request.
         */
        input?: Request | string;
        /**
         * Provided only if the dependency request is a fetch call, this is the init argument being used,
         * re-assigning this value does not change the value used for the request, however, changing properties
         * of this object will be used.
         */
        init?: RequestInit;
        /**
         * Returns the unique identifier for a trace. All requests / spans from the same trace share the same traceId.
         * Must be read from incoming headers or generated according to the W3C TraceContext specification,
         * in a hex representation of 16-byte array. A.k.a. trace-id, TraceID or Distributed TraceID
         */
        traceId?: string;
        /**
         * Self-generated 8-bytes identifier of the incoming request. Must be a hex representation of 8-byte array.
         * Also know as the parentId, used to link requests together
         */
        spanId?: string;
        /**
         * An integer representation of the W3C TraceContext trace-flags.
         * https://www.w3.org/TR/trace-context/#trace-flags
         */
        traceFlags?: number;
    }

    interface IDependencyListenerHandler {
        remove(): void;
    }

    interface IInstrumentationRequirements extends IDependenciesPlugin {
        includeCorrelationHeaders: (ajaxData: ajaxRecord, input?: Request | string, init?: RequestInit, xhr?: XMLHttpRequestInstrumented) => any;
    }

    class XHRMonitoringState {
        openDone: boolean;
        setRequestHeaderDone: boolean;
        sendDone: boolean;
        abortDone: boolean;
        stateChangeAttached: boolean;
        constructor();
    }

    interface XMLHttpRequestInstrumented extends XMLHttpRequest {
        ajaxData: ajaxRecord;
    }

    
}