import { ITelemetryItem, IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
/**
 * Create a telemetry item that the 1DS channel understands
 * @param item domain specific properties; part B
 * @param baseType telemetry item type. ie PageViewData
 * @param envelopeName name of the envelope. ie Microsoft.ApplicationInsights.<instrumentation key>.PageView
 * @param customProperties user defined custom properties; part C
 * @param systemProperties system properties that are added to the context; part A
 * @returns ITelemetryItem that is sent to channel
 */
export declare function createTelemetryItem<T>(item: T, baseType: string, envelopeName: string, logger: IDiagnosticLogger, customProperties?: {
    [key: string]: any;
}, systemProperties?: {
    [key: string]: any;
}): ITelemetryItem;
export declare class TelemetryItemCreator {
    /**
     * Create a telemetry item that the 1DS channel understands
     * @param item domain specific properties; part B
     * @param baseType telemetry item type. ie PageViewData
     * @param envelopeName name of the envelope. ie Microsoft.ApplicationInsights.<instrumentation key>.PageView
     * @param customProperties user defined custom properties; part C
     * @param systemProperties system properties that are added to the context; part A
     * @returns ITelemetryItem that is sent to channel
     */
    static create: typeof createTelemetryItem;
}
