import { IStackFrame } from "../Interfaces/Contracts/IStackFrame";
import { IExceptionData } from "../Interfaces/Contracts/IExceptionData";
import { IExceptionDetails } from "../Interfaces/Contracts/IExceptionDetails";
import { ISerializable } from "../Interfaces/Telemetry/ISerializable";
import { FieldType } from "../Enums";
import { SeverityLevel } from "../Interfaces/Contracts/SeverityLevel";
import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
import { IExceptionInternal, IExceptionDetailsInternal, IExceptionStackFrameInternal, IAutoExceptionTelemetry } from "../Interfaces/IExceptionTelemetry";
/**
 * Formats the provided errorObj for display and reporting, it may be a String, Object, integer or undefined depending on the browser.
 * @param errorObj The supplied errorObj
 */
export declare function _formatErrorCode(errorObj: any): any;
export declare class Exception implements IExceptionData, ISerializable {
    static envelopeType: string;
    static dataType: string;
    id?: string;
    problemGroup?: string;
    isManual?: boolean;
    aiDataContract: {
        ver: FieldType;
        exceptions: FieldType;
        severityLevel: FieldType;
        properties: FieldType;
        measurements: FieldType;
    };
    /**
     * Schema version
     */
    ver: number;
    /**
     * Exception chain - list of inner exceptions.
     */
    exceptions: IExceptionDetails[];
    /**
     * Severity level. Mostly used to indicate exception severity level when it is reported by logging library.
     */
    severityLevel: SeverityLevel;
    /**
     * Collection of custom properties.
     */
    properties: any;
    /**
     * Collection of custom measurements.
     */
    measurements: any;
    /**
     * Constructs a new instance of the ExceptionTelemetry object
     */
    constructor(logger: IDiagnosticLogger, exception: Error | IExceptionInternal | IAutoExceptionTelemetry, properties?: {
        [key: string]: any;
    }, measurements?: {
        [key: string]: number;
    }, severityLevel?: SeverityLevel, id?: string);
    static CreateAutoException(message: string | Event, url: string, lineNumber: number, columnNumber: number, error: any, evt?: Event | string, stack?: string, errorSrc?: string): IAutoExceptionTelemetry;
    static CreateFromInterface(logger: IDiagnosticLogger, exception: IExceptionInternal, properties?: any, measurements?: {
        [key: string]: number;
    }): Exception;
    toInterface(): IExceptionInternal;
    /**
     * Creates a simple exception with 1 stack frame. Useful for manual constracting of exception.
     */
    static CreateSimpleException(message: string, typeName: string, assembly: string, fileName: string, details: string, line: number): Exception;
    static formatError: typeof _formatErrorCode;
}
export declare class _ExceptionDetails implements IExceptionDetails, ISerializable {
    aiDataContract: {
        id: FieldType;
        outerId: FieldType;
        typeName: FieldType;
        message: FieldType;
        hasFullStack: FieldType;
        stack: FieldType;
        parsedStack: FieldType;
    };
    /**
     * In case exception is nested (outer exception contains inner one), the id and outerId properties are used to represent the nesting.
     */
    id: number;
    /**
     * The value of outerId is a reference to an element in ExceptionDetails that represents the outer exception
     */
    outerId: number;
    /**
     * Exception type name.
     */
    typeName: string;
    /**
     * Exception message.
     */
    message: string;
    /**
     * Indicates if full exception stack is provided in the exception. The stack may be trimmed, such as in the case of a StackOverflow exception.
     */
    hasFullStack: boolean;
    /**
     * Text describing the stack. Either stack or parsedStack should have a value.
     */
    stack: string;
    /**
     * List of stack frames. Either stack or parsedStack should have a value.
     */
    parsedStack: IStackFrame[];
    constructor(logger: IDiagnosticLogger, exception: Error | IExceptionDetailsInternal | IAutoExceptionTelemetry, properties?: {
        [key: string]: any;
    });
    toInterface(): IExceptionDetailsInternal;
    static CreateFromInterface(logger: IDiagnosticLogger, exception: IExceptionDetailsInternal): _ExceptionDetails;
}
export declare class _StackFrame implements IStackFrame, ISerializable {
    static regex: RegExp;
    static baseSize: number;
    sizeInBytes: number;
    aiDataContract: {
        level: FieldType;
        method: FieldType;
        assembly: FieldType;
        fileName: FieldType;
        line: FieldType;
    };
    /**
     * Level in the call stack. For the long stacks SDK may not report every function in a call stack.
     */
    level: number;
    /**
     * Method name.
     */
    method: string;
    /**
     * Name of the assembly (dll, jar, etc.) containing this function.
     */
    assembly: string;
    /**
     * File name or URL of the method implementation.
     */
    fileName: string;
    /**
     * Line number of the code implementation.
     */
    line: number;
    constructor(sourceFrame: string | IExceptionStackFrameInternal, level: number);
    static CreateFromInterface(frame: IExceptionStackFrameInternal): _StackFrame;
    toInterface(): {
        level: number;
        method: string;
        assembly: string;
        fileName: string;
        line: number;
    };
}
