import { IDiagnosticLogger, _eInternalMessageId } from "@microsoft/applicationinsights-core-js";
export declare const enum DataSanitizerValues {
    /**
     * Max length allowed for custom names.
     */
    MAX_NAME_LENGTH = 150,
    /**
     * Max length allowed for Id field in page views.
     */
    MAX_ID_LENGTH = 128,
    /**
     * Max length allowed for custom values.
     */
    MAX_PROPERTY_LENGTH = 8192,
    /**
     * Max length allowed for names
     */
    MAX_STRING_LENGTH = 1024,
    /**
     * Max length allowed for url.
     */
    MAX_URL_LENGTH = 2048,
    /**
     * Max length allowed for messages.
     */
    MAX_MESSAGE_LENGTH = 32768,
    /**
     * Max length allowed for exceptions.
     */
    MAX_EXCEPTION_LENGTH = 32768
}
export declare function dataSanitizeKeyAndAddUniqueness(logger: IDiagnosticLogger, key: any, map: any): any;
export declare function dataSanitizeKey(logger: IDiagnosticLogger, name: any): any;
export declare function dataSanitizeString(logger: IDiagnosticLogger, value: any, maxLength?: number): any;
export declare function dataSanitizeUrl(logger: IDiagnosticLogger, url: any): any;
export declare function dataSanitizeMessage(logger: IDiagnosticLogger, message: any): any;
export declare function dataSanitizeException(logger: IDiagnosticLogger, exception: any): any;
export declare function dataSanitizeProperties(logger: IDiagnosticLogger, properties: any): any;
export declare function dataSanitizeMeasurements(logger: IDiagnosticLogger, measurements: any): any;
export declare function dataSanitizeId(logger: IDiagnosticLogger, id: string): string;
export declare function dataSanitizeInput(logger: IDiagnosticLogger, input: any, maxLength: number, _msgId: _eInternalMessageId): any;
export declare function dsPadNumber(num: number): string;
export interface IDataSanitizer {
    /**
     * Max length allowed for custom names.
     */
    MAX_NAME_LENGTH: number;
    /**
     * Max length allowed for Id field in page views.
     */
    MAX_ID_LENGTH: number;
    /**
     * Max length allowed for custom values.
     */
    MAX_PROPERTY_LENGTH: number;
    /**
     * Max length allowed for names
     */
    MAX_STRING_LENGTH: number;
    /**
     * Max length allowed for url.
     */
    MAX_URL_LENGTH: number;
    /**
     * Max length allowed for messages.
     */
    MAX_MESSAGE_LENGTH: number;
    /**
     * Max length allowed for exceptions.
     */
    MAX_EXCEPTION_LENGTH: number;
    sanitizeKeyAndAddUniqueness: (logger: IDiagnosticLogger, key: any, map: any) => string;
    sanitizeKey: (logger: IDiagnosticLogger, name: any) => string;
    sanitizeString: (logger: IDiagnosticLogger, value: any, maxLength?: number) => string;
    sanitizeUrl: (logger: IDiagnosticLogger, url: any) => string;
    sanitizeMessage: (logger: IDiagnosticLogger, message: any) => string;
    sanitizeException: (logger: IDiagnosticLogger, exception: any) => string;
    sanitizeProperties: (logger: IDiagnosticLogger, properties: any) => any;
    sanitizeMeasurements: (logger: IDiagnosticLogger, measurements: any) => any;
    sanitizeId: (logger: IDiagnosticLogger, id: string) => string;
    sanitizeInput: (logger: IDiagnosticLogger, input: any, maxLength: number, _msgId: _eInternalMessageId) => any;
    padNumber: (num: number) => string;
    /**
     * helper method to trim strings (IE8 does not implement String.prototype.trim)
     */
    trim: (str: any) => string;
}
/**
 * Provides the DataSanitizer functions within the previous namespace.
 */
export declare const DataSanitizer: IDataSanitizer;
