import { IData } from "../../Interfaces/Contracts/IData";
import { ISerializable } from "../../Interfaces/Telemetry/ISerializable";
import { FieldType } from "../../Enums";
export declare class Data<TDomain> implements IData<TDomain>, ISerializable {
    /**
     * The data contract for serializing this object.
     */
    aiDataContract: {
        baseType: FieldType;
        baseData: FieldType;
    };
    /**
     * Name of item (B section) if any. If telemetry data is derived straight from this, this should be null.
     */
    baseType: string;
    /**
     * Container for data item (B section).
     */
    baseData: TDomain;
    /**
     * Constructs a new instance of telemetry data.
     */
    constructor(baseType: string, data: TDomain);
}
