import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
/**
 * Disables the global SDK usage of local or session storage if available
 */
export declare function utlDisableStorage(): void;
/**
 * Re-enables the global SDK usage of local or session storage if available
 */
export declare function utlEnableStorage(): void;
/**
 * Returns whether LocalStorage can be used, if the reset parameter is passed a true this will override
 * any previous disable calls.
 * @param reset - Should the usage be reset and determined only based on whether LocalStorage is available
 */
export declare function utlCanUseLocalStorage(reset?: boolean): boolean;
export declare function utlGetLocalStorage(logger: IDiagnosticLogger, name: string): string;
export declare function utlSetLocalStorage(logger: IDiagnosticLogger, name: string, data: string): boolean;
export declare function utlRemoveStorage(logger: IDiagnosticLogger, name: string): boolean;
export declare function utlCanUseSessionStorage(reset?: boolean): boolean;
export declare function utlGetSessionStorageKeys(): string[];
export declare function utlGetSessionStorage(logger: IDiagnosticLogger, name: string): string;
export declare function utlSetSessionStorage(logger: IDiagnosticLogger, name: string, data: string): boolean;
export declare function utlRemoveSessionStorage(logger: IDiagnosticLogger, name: string): boolean;
