import { IDomain } from "./IDomain";
import { IDataPoint } from "./IDataPoint";
/**
 * An instance of the Metric item is a list of measurements (single data points) and/or aggregations.
 */
export interface IMetricData extends IDomain {
    /**
     * Schema version
     */
    ver: number;
    /**
     * List of metrics. Only one metric in the list is currently supported by Application Insights storage. If multiple data points were sent only the first one will be used.
     */
    metrics: IDataPoint[];
    /**
     * Collection of custom properties.
     */
    properties: any;
    /**
     * Collection of custom measurements.
     */
    measurements: any;
}
