/**
 * Type of storage to differentiate between local storage and session storage
 */
export declare const enum eStorageType {
    LocalStorage = 0,
    SessionStorage = 1
}
export declare const StorageType: import("@microsoft/applicationinsights-core-js").EnumValue<typeof eStorageType>;
export declare type StorageType = eStorageType | typeof StorageType;
/**
 * Enum is used in aiDataContract to describe how fields are serialized.
 * For instance: (Fieldtype.Required | FieldType.Array) will mark the field as required and indicate it's an array
 */
export declare const enum FieldType {
    Default = 0,
    Required = 1,
    Array = 2,
    Hidden = 4
}
export declare const enum eDistributedTracingModes {
    /**
     * (Default) Send Application Insights correlation headers
     */
    AI = 0,
    /**
     * Send both W3C Trace Context headers and back-compatibility Application Insights headers
     */
    AI_AND_W3C = 1,
    /**
     * Send W3C Trace Context headers
     */
    W3C = 2
}
export declare const DistributedTracingModes: import("@microsoft/applicationinsights-core-js").EnumValue<typeof eDistributedTracingModes>;
export declare type DistributedTracingModes = number | eDistributedTracingModes;
