// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// THIS FILE WAS AUTOGENERATED
import { IEventData } from "./IEventData";

/**
 * An instance of PageView represents a generic action on a page like a button click. It is also the base type for PageView.
 */
export interface IPageViewData extends IEventData {

    /**
     * Request URL with all query string parameters
     */
    url: string;

    /**
     * Request duration in format: DD.HH:MM:SS.MMMMMM. For a page view (PageViewData), this is the duration. For a page view with performance information (PageViewPerfData), this is the page load time. Must be less than 1000 days.
     */
    duration: string;

    /**
     * Identifier of a page view instance. Used for correlation between page view and other telemetry items.
     */
    id: string;
}
