/*
 * Application Insights JavaScript SDK - Common, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { dataSanitizeMessage, dataSanitizeProperties, dataSanitizeMeasurements } from "./Common/DataSanitizer";
import { strNotSpecified } from "../Constants";
var Trace = /** @class */ (function () {
    /**
     * Constructs a new instance of the TraceTelemetry object
     */
    function Trace(logger, message, severityLevel, properties, measurements) {
        this.aiDataContract = {
            ver: 1 /* FieldType.Required */,
            message: 1 /* FieldType.Required */,
            severityLevel: 0 /* FieldType.Default */,
            properties: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        message = message || strNotSpecified;
        _self.message = dataSanitizeMessage(logger, message);
        _self.properties = dataSanitizeProperties(logger, properties);
        _self.measurements = dataSanitizeMeasurements(logger, measurements);
        if (severityLevel) {
            _self.severityLevel = severityLevel;
        }
    }
    Trace.envelopeType = "Microsoft.ApplicationInsights.{0}.Message";
    Trace.dataType = "MessageData";
    return Trace;
}());
export { Trace };
//# sourceMappingURL=Trace.js.map