import { ISenderConfig, XDomainRequest as IXDomainRequest, IBackendResponse } from "./Interfaces";
import { ISendBuffer } from "./SendBuffer";
import { IEnvelope, IChannelControlsAI, IConfig, ISample } from "@microsoft/applicationinsights-common";
import { ITelemetryItem, IProcessTelemetryContext, IConfiguration, IDiagnosticLogger, IAppInsightsCore, IPlugin, BaseTelemetryPlugin, ITelemetryPluginChain, SendRequestReason } from "@microsoft/applicationinsights-core-js";
export declare type SenderFunction = (payload: string[], isAsync: boolean) => void;
export declare class Sender extends BaseTelemetryPlugin implements IChannelControlsAI {
    static constructEnvelope(orig: ITelemetryItem, iKey: string, logger: IDiagnosticLogger, convertUndefined?: any): IEnvelope;
    readonly priority: number;
    readonly identifier: string;
    /**
     * The configuration for this sender instance
     */
    readonly _senderConfig: ISenderConfig;
    /**
     * A method which will cause data to be send to the url
     */
    _sender: SenderFunction;
    /**
     * A send buffer object
     */
    _buffer: ISendBuffer;
    /**
     * AppId of this component parsed from some backend response.
     */
    _appId: string;
    protected _sample: ISample;
    constructor();
    /**
     * Pause the sending (transmission) of events, this will cause all events to be batched only until the maximum limits are
     * hit at which point new events are dropped. Will also cause events to NOT be sent during page unload, so if Session storage
     * is disabled events will be lost.
     * SessionStorage Limit is 2000 events, In-Memory (Array) Storage is 10,000 events (can be configured via the eventsLimitInMem).
     */
    pause(): void;
    /**
     * Resume the sending (transmission) of events, this will restart the timer and any batched events will be sent using the normal
     * send interval.
     */
    resume(): void;
    /**
     * Flush the batched events immediately (not synchronously).
     * Will not flush if the Sender has been paused.
     */
    flush(): void;
    /**
     * Flush the batched events synchronously (if possible -- based on configuration).
     * Will not flush if the Send has been paused.
     */
    onunloadFlush(): void;
    initialize(config: IConfiguration & IConfig, core: IAppInsightsCore, extensions: IPlugin[], pluginChain?: ITelemetryPluginChain): void;
    processTelemetry(telemetryItem: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    /**
     * xhr state changes
     */
    _xhrReadyStateChange(xhr: XMLHttpRequest, payload: string[], countOfItemsInPayload: number): void;
    /**
     * Immediately send buffered data
     * @param async {boolean} - Indicates if the events should be sent asynchronously
     * @param forcedSender {SenderFunction} - Indicates the forcedSender, undefined if not passed
     */
    triggerSend(async?: boolean, forcedSender?: SenderFunction, sendReason?: SendRequestReason): void;
    /**
     * error handler
     */
    _onError(payload: string[], message: string, event?: ErrorEvent): void;
    /**
     * partial success handler
     */
    _onPartialSuccess(payload: string[], results: IBackendResponse): void;
    /**
     * success handler
     */
    _onSuccess(payload: string[], countOfItemsInPayload: number): void;
    /**
     * xdr state changes
     */
    _xdrOnLoad(xdr: IXDomainRequest, payload: string[]): void;
    /**
     * Add header to request
     * @param name   - Header name.
     * @param value  - Header value.
     */
    addHeader(name: string, value: string): void;
}
