import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
import { ISenderConfig } from "./Interfaces";
export interface ISendBuffer {
    /**
     * Enqueue the payload
     */
    enqueue: (payload: string) => void;
    /**
     * Returns the number of elements in the buffer
     */
    count: () => number;
    /**
     * Returns the current size of the serialized buffer
     */
    size: () => number;
    /**
     * Clears the buffer
     */
    clear: () => void;
    /**
     * Returns items stored in the buffer
     */
    getItems: () => string[];
    /**
     * Build a batch of all elements in the payload array
     */
    batchPayloads: (payload: string[]) => string;
    /**
     * Moves items to the SENT_BUFFER.
     * The buffer holds items which were sent, but we haven't received any response from the backend yet.
     */
    markAsSent: (payload: string[]) => void;
    /**
     * Removes items from the SENT_BUFFER. Should be called on successful response from the backend.
     */
    clearSent: (payload: string[]) => void;
}
declare abstract class BaseSendBuffer {
    protected _get: () => string[];
    protected _set: (buffer: string[]) => string[];
    constructor(logger: IDiagnosticLogger, config: ISenderConfig);
    enqueue(payload: string): void;
    count(): number;
    size(): number;
    clear(): void;
    getItems(): string[];
    batchPayloads(payload: string[]): string;
}
export declare class ArraySendBuffer extends BaseSendBuffer implements ISendBuffer {
    constructor(logger: IDiagnosticLogger, config: ISenderConfig);
    markAsSent(payload: string[]): void;
    clearSent(payload: string[]): void;
}
export declare class SessionStorageSendBuffer extends BaseSendBuffer implements ISendBuffer {
    static BUFFER_KEY: string;
    static SENT_BUFFER_KEY: string;
    static MAX_BUFFER_SIZE: number;
    constructor(logger: IDiagnosticLogger, config: ISenderConfig);
    enqueue(payload: string): void;
    clear(): void;
    markAsSent(payload: string[]): void;
    clearSent(payload: string[]): void;
}
export {};
