import { IPageViewTelemetry, IPageViewTelemetryInternal, IPageViewPerformanceTelemetryInternal } from "@microsoft/applicationinsights-common";
import { IAppInsightsCore, IProcessTelemetryUnloadContext, ITelemetryUnloadState } from "@microsoft/applicationinsights-core-js";
import { PageViewPerformanceManager } from "./PageViewPerformanceManager";
/**
 * Internal interface to pass appInsights object to subcomponents without coupling
 */
export interface IAppInsightsInternal {
    sendPageViewInternal(pageViewItem: IPageViewTelemetryInternal, properties?: Object, systemProperties?: Object): void;
    sendPageViewPerformanceInternal(pageViewPerformance: IPageViewPerformanceTelemetryInternal, properties?: Object, systemProperties?: Object): void;
}
/**
 * Class encapsulates sending page views and page view performance telemetry.
 */
export declare class PageViewManager {
    constructor(appInsights: IAppInsightsInternal, overridePageViewDuration: boolean, core: IAppInsightsCore, pageViewPerformanceManager: PageViewPerformanceManager);
    /**
     * Currently supported cases:
     * 1) (default case) track page view called with default parameters, overridePageViewDuration = false. Page view is sent with page view performance when navigation timing data is available.
     *    a. If navigation timing is not supported then page view is sent right away with undefined duration. Page view performance is not sent.
     * 2) overridePageViewDuration = true, custom duration provided. Custom duration is used, page view sends right away.
     * 3) overridePageViewDuration = true, custom duration NOT provided. Page view is sent right away, duration is time spent from page load till now (or undefined if navigation timing is not supported).
     * 4) overridePageViewDuration = false, custom duration is provided. Page view is sent right away with custom duration.
     *
     * In all cases page view performance is sent once (only for the 1st call of trackPageView), or not sent if navigation timing is not supported.
     */
    trackPageView(pageView: IPageViewTelemetry, customProperties?: {
        [key: string]: any;
    }): void;
    teardown(unloadCtx?: IProcessTelemetryUnloadContext, unloadState?: ITelemetryUnloadState): void;
}
