/*
 * Application Insights JavaScript SDK - Web Analytics, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { dateTimeUtilsDuration } from "@microsoft/applicationinsights-common";
import { _throwInternal } from "@microsoft/applicationinsights-core-js";
/**
 * Used to record timed events and page views.
 */
var Timing = /** @class */ (function () {
    function Timing(logger, name) {
        var _self = this;
        var _events = {};
        _self.start = function (name) {
            if (typeof _events[name] !== "undefined") {
                _throwInternal(logger, 2 /* eLoggingSeverity.WARNING */, 62 /* _eInternalMessageId.StartCalledMoreThanOnce */, "start was called more than once for this event without calling stop.", { name: name, key: name }, true);
            }
            _events[name] = +new Date;
        };
        _self.stop = function (name, url, properties, measurements) {
            var start = _events[name];
            if (isNaN(start)) {
                _throwInternal(logger, 2 /* eLoggingSeverity.WARNING */, 63 /* _eInternalMessageId.StopCalledWithoutStart */, "stop was called without a corresponding start.", { name: name, key: name }, true);
            }
            else {
                var end = +new Date;
                var duration = dateTimeUtilsDuration(start, end);
                _self.action(name, url, duration, properties, measurements);
            }
            delete _events[name];
            _events[name] = undefined;
        };
    }
    return Timing;
}());
export { Timing };
//# sourceMappingURL=Timing.js.map