# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    # Remove vulnerability finding link records
    # The records will be repopulated from the `raw_metadata`
    # column of `vulnerability_occurrences` once the unique
    # index is in place.
    class RemoveVulnerabilityFindingLinks
      include Gitlab::Database::DynamicModelHelpers

      def perform(start_id, stop_id)
        define_batchable_model('vulnerability_finding_links', connection: ApplicationRecord.connection)
          .where(id: start_id..stop_id)
          .delete_all
      end
    end
  end
end
