---
stage: Manage
group: Workspace
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Workspace

DISCLAIMER:
This page contains information related to upcoming products, features, and functionality.
It is important to note that the information presented is for informational purposes only.
Please do not rely on this information for purchasing or planning purposes.
As with all projects, the items mentioned on this page are subject to change or delay.
The development, release, and timing of any products, features, or functionality remain at the
sole discretion of GitLab Inc.

NOTE:
Workspace is currently in development.

Workspace will be above the [top-level namespaces](../namespace/index.md) for you to manage
everything you do as a GitLab administrator, including:

- Defining and applying settings to all of your groups, subgroups, and projects.
- Aggregating data from all your groups, subgroups, and projects.

Our goal is to reach feature parity between SaaS and self-managed installations, with all
[Admin Area settings](/ee/user/admin_area/settings/index.md) moving to either:

- Groups. Available in the Workspace, top-level group namespaces, and subgroups.
- Hardware Controls. For functionality that does not apply to groups, Hardware Controls are only
  applicable to self-managed installations. There is one Hardware Controls section per installation.

To learn about the current state of workspace development,
see [epic 4257](https://gitlab.com/groups/gitlab-org/-/epics/4257).

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
For a video introduction to the new hierarchy concept for groups and projects for epics, see
[Consolidating groups and projects update (August 2021)](https://www.youtube.com/watch?v=fE74lsG_8yM).

## Related topics

- [Workspace developer documentation](../../development/workspace/index.md)
