---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Invalid Sub-Resource Integrity values detected

## Description

JavaScript or CSS source files were found to contain invalid
[Sub-Resource Integrity (SRI)](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity)
`integrity` values or a missing `crossorigin` value. These scripts or links should be investigated to
ensure they have not been maliciously altered. If in doubt, contact the owner of the scripts or replace
them with known good versions.

## Remediation

All identified resources should be sourced from the same domain as the target application. If this is not
possible, it is strongly recommended that all `script` tags that implement `src` values, or `link` tags
that implement the `href` values include Sub-Resource Integrity. To generate SRI integrity values the
[srihash](https://www.srihash.org/) tool can be used, or by running one of the following commands:

- `cat FILENAME.js | openssl dgst -sha384 -binary | openssl base64 -A`
- `shasum -b -a 384 FILENAME.js | awk '{ print $1 }' | xxd -r -p | base64`

The output of these tools must be added as additional attributes, in particular: `integrity` and either
`crossorigin=anonymous` or `crossorigin=use-credentials`.
An example of a valid SRI protected script tag can be found below:

```html
<script src="https://example.com/example-framework.js"
    integrity="sha384-oqVuAfXRKap7fdgcCY5uykM6+R9GqQ8K/uxy9rx7HNQlGYl1kPzQho1wx4JwY8wC"
    crossorigin="anonymous"></script>
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 829.2 | true | 829 | Passive | Medium |

## Links

- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Third_Party_Javascript_Management_Cheat_Sheet.html#subresource-integrity)
- [CWE](https://cwe.mitre.org/data/definitions/829.html)
- [MDN](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity)
