---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Generation of error message containing sensitive information

## Description

The application was found to return error data such as stack traces. Depending on the data contained within the error message,
this information could be used by an attacker to conduct further attacks. While stack traces are helpful during development
and debugging, they should not be presented to users when an error occurs.

## Remediation

Applications should handle exception conditions internally and map known failure types to error codes that can be displayed
to a user. These error codes should be customized to the application and returned along with the relevant HTTP error code.

When an error occurs, the application identifies the error type or class, and displays a numerical value to the
user. Requests should also be tracked so when a user is presented with an error code, it has a corresponding request ID.
Support teams can then correlate the HTTP error, the customized error code, and the request ID in the log files to
determine the root cause of the error without leaking details to the end user.

Example of returning customized errors:

```plaintext
HTTP/1.1 500 Internal Server Error
...
Error [0004] Occurred, please contact support or re-try your request again shortly.
Request ID [a4bc91def12]
...
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 209.1 | false | 209 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/209.html)
