---
stage: Manage
group: Integrations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Jira integrations **(FREE)**

If your organization uses [Jira](https://www.atlassian.com/software/jira) issues,
you can [migrate your issues from Jira](../../user/project/import/jira.md) and work
exclusively in GitLab. However, if you'd like to continue to use Jira, you can
integrate it with GitLab. GitLab offers two types of Jira integrations, and you
can use one or both depending on the capabilities you need. We recommend you enable both.

## Compare integrations

After you set up one or both of these integrations, you can cross-reference activity
in your GitLab project with any of your projects in Jira.

### Jira integration

This integration connects one or more GitLab projects to a Jira instance. The Jira instance
can be hosted by you or in [Atlassian cloud](https://www.atlassian.com/migration/assess/why-cloud).
The supported Jira versions are `v6.x`, `v7.x`, and `v8.x`.

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
For an overview, see [Agile Management - GitLab-Jira Basic Integration](https://www.youtube.com/watch?v=fWvwkx5_00E&feature=youtu.be).

To set up the integration, [configure the settings](configure.md) in GitLab.

### Jira development panel integration

The [Jira development panel integration](development_panel.md)
connects all GitLab projects under a group or personal namespace. When configured,
relevant GitLab information, including related branches, commits, and merge requests,
displays in the [development panel](https://support.atlassian.com/jira-software-cloud/docs/view-development-information-for-an-issue/).

To set up the Jira development panel integration, use the GitLab.com for Jira Cloud app
or the Jira DVCS (distributed version control system) connector,
[depending on your installation](development_panel.md#configure-the-integration).

### Direct feature comparison

| Capability | Jira integration | Jira development panel integration |
|-|-|-|
| Mention a Jira issue ID in a GitLab commit or merge request, and a link to the Jira issue is created. | Yes. | No. |
| Mention a Jira issue ID in GitLab and the Jira issue shows the GitLab issue or merge request. | Yes. A Jira comment with the GitLab issue or MR title links to GitLab. The first mention is also added to the Jira issue under **Web links**. | Yes, in the issue's [development panel](https://support.atlassian.com/jira-software-cloud/docs/view-development-information-for-an-issue/). |
| Mention a Jira issue ID in a GitLab commit message and the Jira issue shows the commit message. | Yes. The entire commit message is displayed in the Jira issue as a comment and under **Web links**. Each message links back to the commit in GitLab. | Yes, in the issue's [development panel](https://support.atlassian.com/jira-software-cloud/docs/view-development-information-for-an-issue/) and optionally with a custom comment on the Jira issue using Jira [Smart Commits](https://confluence.atlassian.com/fisheye/using-smart-commits-960155400.html). |
| Mention a Jira issue ID in a GitLab branch name and the Jira issue shows the branch name. | No. | Yes, in the issue's [development panel](https://support.atlassian.com/jira-software-cloud/docs/view-development-information-for-an-issue/). |
| Add Jira time tracking to an issue. | No. | Yes. Time can be specified using Jira Smart Commits. |
| Use a Git commit or merge request to transition or close a Jira issue. | Yes. Only a single transition type, typically configured to close the issue by setting it to Done. | Yes. Transition to any state using Jira Smart Commits. |
| Display a list of [Jira issues](issues.md#view-jira-issues). | Yes. | No. |
| Create a Jira issue from a [vulnerability or finding](../../user/application_security/vulnerabilities/index.md#create-a-jira-issue-for-a-vulnerability). | Yes. | No. |
| Create a GitLab branch from a Jira issue. | No. | Yes, in the issue's [development panel](https://support.atlassian.com/jira-software-cloud/docs/view-development-information-for-an-issue/). |

## Authentication in Jira

The authentication method in Jira depends on whether you host Jira on your own server or on
[Atlassian cloud](https://www.atlassian.com/migration/assess/why-cloud):

- **Jira Server** supports basic authentication. When connecting, a **username and password** are
  required. Connecting to Jira Server using the Central Authentication Service (CAS) is not possible. For more information, read
  how to [set up a user in Jira Server](jira_server_configuration.md).
- **Jira on Atlassian cloud** supports authentication through an API token. When connecting to Jira on
  Atlassian cloud, an email and API token are required. For more information, read
  [create an API token for Jira in Atlassian cloud](jira_cloud_configuration.md).

## Privacy considerations

All Jira integrations share data with Jira to make it visible outside of GitLab.
If you integrate a private GitLab project with Jira, the private data is
shared with users who have access to your Jira project.

The [**Jira project integration**](#jira-integration) posts GitLab data in the form of comments in Jira issues.
The GitLab.com for Jira Cloud app and Jira DVCS connector share this data through the [**Jira Development Panel**](development_panel.md).
This method provides more fine-grained access control because access can be restricted to certain user groups or roles.

## Third-party Jira integrations

Developers have built several third-party Jira integrations for GitLab that are
listed on the [Atlassian Marketplace](https://marketplace.atlassian.com/search?product=jira&query=gitlab).

## Troubleshooting

If these features do not work as expected, it is likely due to a problem with the way the integration settings were configured.

### GitLab cannot comment on a Jira issue

If GitLab cannot comment on Jira issues, make sure the Jira user you
set up for the integration has permission to:

- Post comments on a Jira issue.
- Transition the Jira issue.

Jira issue references and update comments do not work if the GitLab issue tracker is disabled.

If you [restrict IP addresses for Jira access](https://support.atlassian.com/security-and-access-policies/docs/specify-ip-addresses-for-product-access/), make sure you add your self-managed IP addresses or [GitLab.com IP range](../../user/gitlab_com/index.md#ip-range) to the allowlist in Jira.

### GitLab cannot close a Jira issue

If GitLab cannot close a Jira issue:

- Make sure the `Transition ID` you set in the Jira settings matches the one
  your project needs to close an issue.

- Make sure the Jira issue is not already marked as resolved:
  - Check the Jira issue resolution field is not set.
  - Check the issue is not struck through in Jira lists.

### CAPTCHA

CAPTCHA may be triggered after several consecutive failed login attempts,
which may lead to a `401 unauthorized` error when testing your Jira integration.
If CAPTCHA has been triggered, you can't use Jira's REST API to
authenticate with the Jira site.

To fix this error, sign in to your Jira instance
and complete the CAPTCHA.

### Jira integration does not work for imported project

There is a [known bug](https://gitlab.com/gitlab-org/gitlab/-/issues/341571)
where the Jira integration sometimes does not work for a project that has been imported.
As a workaround, disable the integration and then re-enable it.

### Bulk change all Jira integrations to Jira instance-level values

To change all Jira projects to use instance-level integration settings:

1. In a [Rails console](../../administration/operations/rails_console.md#starting-a-rails-console-session), run the following:

   ```ruby
   jira_integration_instance_id = Integrations::Jira.find_by(instance: true).id
   Integrations::Jira.where(active: true, instance: false, template: false, inherit_from_id: nil).find_each do |integration|
     integration.update_attribute(:inherit_from_id, jira_integration_instance_id)
   end
   ```

1. Modify and save the instance-level integration from the UI to propagate the changes to all group-level and project-level integrations.

### Check if Jira Cloud is linked

You can use the [Rails console](../../administration/operations/rails_console.md#starting-a-rails-console-session) to check if Jira Cloud is linked to:

A specified namespace:

```ruby
JiraConnectSubscription.where(namespace: Namespace.by_path('group/subgroup'))
```

A specified project:

```ruby
Project.find_by_full_path('path/to/project').jira_subscription_exists?
```

Any namespace:

```ruby
installation = JiraConnectInstallation.find_by_base_url("https://customer_name.atlassian.net")
installation.subscriptions
```

### Bulk update the service integration password for all projects

To reset the Jira user's password for all projects with active Jira integrations,
run the following in a [Rails console](../../administration/operations/rails_console.md#starting-a-rails-console-session):

```ruby
p = Project.find_by_sql("SELECT p.id FROM projects p LEFT JOIN services s ON p.id = s.project_id WHERE s.type = 'JiraService' AND s.active = true")

p.each do |project|
  project.jira_integration.update_attribute(:password, '<your-new-password>')
end
```

### `500 Whoops` when accessing a Jira issue in GitLab

When accessing a Jira issue in GitLab, you might get a `500 Whoops, something went wrong on our end` error.
Check [`production.log`](../../administration/logs/index.md#productionlog) to see if it contains a `:NoMethodError (undefined method 'duedate' for #<JIRA::Resource::Issue:0x00007f406d7b3180>)` exception. If that's the case, ensure the **Due date** field is visible for issues in the integrated Jira project.
