---
comments: false
type: index, dev
stage: none
group: Development
info: "See the Technical Writers assigned to Development Guidelines: https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-development-guidelines"
description: "Development Guidelines: learn how to contribute to GitLab."
---

# Contribute to the development of GitLab

Learn how to contribute to the development of the GitLab product.

This content is intended for members of the GitLab Team as well as community
contributors. Content specific to the GitLab Team should instead be included in
the [Handbook](https://about.gitlab.com/handbook/).

For information on using GitLab to work on your own software projects, see the
[GitLab user documentation](../user/index.md).

For information on working with the GitLab APIs, see the [API documentation](../api/index.md).

For information about how to install, configure, update, and upgrade your own
GitLab instance, see the [Administrator documentation](../administration/index.md).

## Get started

- Set up the GitLab development environment with the
  [GitLab Development Kit (GDK)](https://gitlab.com/gitlab-org/gitlab-development-kit/-/blob/main/README.md)
- [GitLab contributing guide](contributing/index.md)
  - [Issues workflow](contributing/issue_workflow.md) for more information about:
    - Issue tracker guidelines.
    - Triaging.
    - Labels.
    - Feature proposals.
    - Issue weight.
    - Regression issues.
    - Technical or UX debt.
  - [Merge requests workflow](contributing/merge_request_workflow.md) for more
    information about:
    - Merge request guidelines.
    - Contribution acceptance criteria.
    - Definition of done.
    - Dependencies.
  - [Style guides](contributing/style_guides.md)
  - [Implement design & UI elements](contributing/design.md)
- [GitLab Architecture Overview](architecture.md)
- [Rake tasks](rake_tasks.md) for development
