---
stage: Govern
group: Threat Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Vulnerability Findings API **(ULTIMATE)**

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/19029) in GitLab 12.5.

NOTE:
This API resource is renamed from Vulnerabilities to Vulnerability Findings because the Vulnerabilities are reserved
for serving [Vulnerability objects](https://gitlab.com/gitlab-org/gitlab/-/issues/13561).
To fix any broken integrations with the former Vulnerabilities API, change the `vulnerabilities` URL part to be
`vulnerability_findings`.

Every API call to vulnerability findings must be [authenticated](index.md#authentication).

Vulnerability findings are project-bound entities. If a user is not
a member of a project and the project is private, a request on
that project results in a `404` status code.

If a user is able to access the project but does not have permission to
[use the Project Security Dashboard](../user/permissions.md#project-members-permissions),
any request for vulnerability findings of this project results in a `403` status code.

WARNING:
This API is in the process of being deprecated and considered unstable.
The response payload may be subject to change or breakage
across GitLab releases. Please use the
[GraphQL API](graphql/reference/index.md#queryvulnerabilities)
instead. See the [GraphQL examples](#replace-vulnerability-findings-rest-api-with-graphql) to get started.

## Vulnerability findings pagination

By default, `GET` requests return 20 results at a time because the API results
are paginated.

Read more on [pagination](index.md#pagination).

## List project vulnerability findings

List all of a project's vulnerability findings.

```plaintext
GET /projects/:id/vulnerability_findings
GET /projects/:id/vulnerability_findings?report_type=sast
GET /projects/:id/vulnerability_findings?report_type=container_scanning
GET /projects/:id/vulnerability_findings?report_type=sast,dast
GET /projects/:id/vulnerability_findings?scope=all
GET /projects/:id/vulnerability_findings?scope=dismissed
GET /projects/:id/vulnerability_findings?severity=high
GET /projects/:id/vulnerability_findings?confidence=unknown,experimental
GET /projects/:id/vulnerability_findings?pipeline_id=42
```

WARNING:
Beginning with GitLab 12.9, the `undefined` severity and confidence level is no longer reported.

| Attribute     | Type           | Required | Description                                                                                                                                                                         |
| ------------- | -------------- | -------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `id`          | integer/string | yes      | The ID or [URL-encoded path of the project](index.md#namespaced-path-encoding) which the authenticated user is a member of.                                                        |
| `report_type` | string array   | no       | Returns vulnerability findings belonging to specified report type. Valid values: `sast`, `dast`, `dependency_scanning`, or `container_scanning`. Defaults to all.                   |
| `scope`       | string         | no       | Returns vulnerability findings for the given scope: `all` or `dismissed`. Defaults to `dismissed`.                                                                                  |
| `severity`    | string array   | no       | Returns vulnerability findings belonging to specified severity level: `info`, `unknown`, `low`, `medium`, `high`, or `critical`. Defaults to all.                                   |
| `confidence`  | string array   | no       | Returns vulnerability findings belonging to specified confidence level: `ignore`, `unknown`, `experimental`, `low`, `medium`, `high`, or `confirmed`. Defaults to all.              |
| `pipeline_id` | integer/string | no       | Returns vulnerability findings belonging to specified pipeline.                                                                                                                     |

```shell
curl --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/projects/4/vulnerability_findings"
```

Example response:

```json
[
  {
    "id": null,
    "report_type": "sast",
    "name": "Possible command injection",
    "severity": "high",
    "confidence": "high",
    "scanner": {
      "external_id": "brakeman",
      "name": "Brakeman",
      "vendor": "GitLab"
    },
    "identifiers": [
      {
        "external_type": "brakeman_warning_code",
        "external_id": "14",
        "name": "Brakeman Warning Code 14",
        "url": "https://brakemanscanner.org/docs/warning_types/command_injection/"
      }
    ],
    "project_fingerprint": "ac218b1770af030cfeef967752ab803c55afb36d",
    "uuid": "ad5e3be3-a193-55f5-a200-bc12865fb09c",
    "create_jira_issue_url": null,
    "false_positive": true,
    "create_vulnerability_feedback_issue_path": "/root/test-false-positive/-/vulnerability_feedback",
    "create_vulnerability_feedback_merge_request_path": "/root/test-false-positive/-/vulnerability_feedback",
    "create_vulnerability_feedback_dismissal_path": "/root/test-false-positive/-/vulnerability_feedback",
    "project": {
      "id": 2,
      "name": "Test False Positive",
      "full_path": "/root/test-false-positive",
      "full_name": "Administrator / Test False Positive"
    },
    "dismissal_feedback": null,
    "issue_feedback": null,
    "merge_request_feedback": null,
    "description": null,
    "links": [],
    "location": {
      "file": "app/controllers/users_controller.rb",
      "start_line": 42,
      "class": "UsersController",
      "method": "list_users"
    },
    "remediations": [
      null
    ],
    "solution": null,
    "evidence": null,
    "request": null,
    "response": null,
    "evidence_source": null,
    "supporting_messages": [],
    "assets": [],
    "details": {},
    "state": "detected",
    "scan": {
      "type": "sast",
      "status": "success",
      "start_time": "2021-09-02T20:55:48",
      "end_time": "2021-09-02T20:55:48"
    },
    "blob_path": "/root/test-false-positive/-/blob/dfd75607752a839bbc9c7362d111effaa470fecd/app/controllers/users_controller.rb#L42"
  }
]
```

## Replace Vulnerability Findings REST API with GraphQL

To prepare for the [upcoming deprecation](https://gitlab.com/groups/gitlab-org/-/epics/5118) of
the Vulnerability Findings REST API endpoint, use the examples below to perform the equivalent operations
with the GraphQL API.

### GraphQL - Project vulnerabilities

Use [`Project.vulnerabilities`](graphql/reference/index.md#projectvulnerabilities).

```graphql
{
  project(fullPath: "root/security-reports") {
    vulnerabilities {
      nodes{
        id
        reportType
        title
        severity
        scanner {
          externalId
          name
          vendor
        }
        identifiers {
          externalType
          externalId
          name
          url
        }
        falsePositive
        project {
          id
          name
          fullPath
        }
        description
        links {
          name
          url
        }
        location {
          ... on
          VulnerabilityLocationSast {
            file
            startLine
            endLine
            vulnerableClass
            vulnerableMethod
            blobPath
          }
        }
        details {
          ... on
          VulnerabilityDetailCode {
            description
            fieldName
            lang
            name
            value
          }
        }
        state
      }
    }
  }
}
```

Example response:

```json
{
  "data": {
    "project": {
      "vulnerabilities": {
        "nodes": [
          {
            "id": "gid://gitlab/Vulnerability/236",
            "reportType": "SAST",
            "title": "Generic Object Injection Sink",
            "severity": "CRITICAL",
            "scanner": {
              "externalId": "eslint",
              "name": "ESLint",
              "vendor": "GitLab"
            },
            "identifiers": [
              {
                "externalType": "eslint_rule_id",
                "externalId": "security/detect-object-injection",
                "name": "ESLint rule ID security/detect-object-injection",
                "url": "https://github.com/nodesecurity/eslint-plugin-security#detect-object-injection"
              },
              {
                "externalType": "cwe",
                "externalId": "94",
                "name": "CWE-94",
                "url": "https://cwe.mitre.org/data/definitions/94.html"
              }
            ],
            "falsePositive": false,
            "project": {
              "id": "gid://gitlab/Project/20",
              "name": "Security Reports",
              "fullPath": "root/security-reports"
            },
            "description": "Bracket object notation with user input is present, this might allow an attacker to access all properties of the object and even it's prototype, leading to possible code execution.",
            "links": [],
            "location": {
              "file": "src/js/main.js",
              "startLine": "28",
              "endLine": "28",
              "vulnerableClass": null,
              "vulnerableMethod": null,
              "blobPath": "/root/security-reports/-/blob/91031428a5b5dbb81e8d889738b1875c1bfea787/src/js/main.js"
            },
            "details": [],
            "state": "DETECTED"
          }
        ]
      }
    }
  }
}
```
