---
stage: Govern
group: Threat Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Vulnerability export API **(ULTIMATE)**

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/197494) in GitLab 12.10. [Updated](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/30397) in GitLab 13.0.

WARNING:
This API is in an [Alpha](../policy/alpha-beta-support.md#alpha-features) stage and considered unstable.
The response payload may be subject to change or breakage
across GitLab releases.

Every API call to vulnerability exports must be [authenticated](index.md#authentication).

## Create a project-level vulnerability export

Creates a new vulnerability export for a project.

Vulnerability export permissions inherit permissions from their project. If a project is
private and a user isn't a member of the project to which the vulnerability
belongs, requests to that project return a `404 Not Found` status code.
Vulnerability exports can be only accessed by the export's author.

If an authenticated user doesn't have permission to
[create a new vulnerability](../user/permissions.md#project-members-permissions),
this request results in a `403` status code.

```plaintext
POST /security/projects/:id/vulnerability_exports
```

| Attribute           | Type              | Required   | Description                                                                                                                  |
| ------------------- | ----------------- | ---------- | -----------------------------------------------------------------------------------------------------------------------------|
| `id`                | integer or string | yes        | The ID or [URL-encoded path](index.md#namespaced-path-encoding) of the project which the authenticated user is a member of |

```shell
curl --request POST --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/projects/1/vulnerability_exports"
```

The created vulnerability export is automatically deleted after 1 hour.

Example response:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": 1,
  "group_id": null,
  "format": "csv",
  "status": "created",
  "started_at": null,
  "finished_at": null,
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
  }
}
```

## Create a group-level vulnerability export

Creates a new vulnerability export for a group.

Vulnerability export permissions inherit permissions from their group. If a group is
private and a user isn't a member of the group to which the vulnerability
belongs, requests to that group return a `404 Not Found` status code.
Vulnerability exports can be only accessed by the export's author.

If an authenticated user doesn't have permission to
[create a new vulnerability](../user/permissions.md#group-members-permissions),
this request results in a `403` status code.

```plaintext
POST /security/groups/:id/vulnerability_exports
```

| Attribute           | Type              | Required   | Description                                                                                                                  |
| ------------------- | ----------------- | ---------- | -----------------------------------------------------------------------------------------------------------------------------|
| `id`                | integer or string | yes        | The ID or [URL-encoded path](index.md#namespaced-path-encoding) of the group which the authenticated user is a member of |

```shell
curl --request POST --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/groups/1/vulnerability_exports"
```

The created vulnerability export is automatically deleted after 1 hour.

Example response:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": null,
  "group_id": 1,
  "format": "csv",
  "status": "created",
  "started_at": null,
  "finished_at": null,
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
  }
}
```

## Create an instance-level vulnerability export

Creates a new vulnerability export for the projects of the user selected in the Security Dashboard.

```plaintext
POST /security/vulnerability_exports
```

```shell
curl --request POST --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/vulnerability_exports"
```

The created vulnerability export is automatically deleted after one hour.

Example response:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": null,
  "group_id": null,
  "format": "csv",
  "status": "created",
  "started_at": null,
  "finished_at": null,
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
  }
}
```

## Get single vulnerability export

Gets a single vulnerability export.

```plaintext
GET /security/vulnerability_exports/:id
```

| Attribute | Type | Required | Description |
| --------- | ---- | -------- | ----------- |
| `id` | integer or string | yes | The vulnerability export's ID |

```shell
curl --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/vulnerability_exports/2"
```

If the vulnerability export isn't finished, the response is `202 Accepted`.

Example response:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": 1,
  "group_id": null,
  "format": "csv",
  "status": "finished",
  "started_at": "2020-03-30T09:36:54.469Z",
  "finished_at": "2020-03-30T09:36:55.008Z",
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
  }
}
```

## Download vulnerability export

Downloads a single vulnerability export.

```plaintext
GET /security/vulnerability_exports/:id/download
```

| Attribute | Type | Required | Description |
| --------- | ---- | -------- | ----------- |
| `id` | integer or string | yes | The vulnerability export's ID |

```shell
curl --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
```

The response is `404 Not Found` if the vulnerability export is not finished yet or was not found.

Example response:

```csv
Group Name,Project Name,Tool,Scanner Name,Status,Vulnerability,Details,Additional Info,Severity,CVE,CWE,Other Identifiers
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2017-16997 in glibc,,CVE-2017-16997 in glibc,critical,CVE-2017-16997
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2017-18269 in glibc,,CVE-2017-18269 in glibc,critical,CVE-2017-18269
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2018-1000001 in glibc,,CVE-2018-1000001 in glibc,high,CVE-2018-1000001
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2016-10228 in glibc,,CVE-2016-10228 in glibc,medium,CVE-2016-10228
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2010-4052 in glibc,,CVE-2010-4052 in glibc,low,CVE-2010-4052
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2018-18520 in elfutils,,CVE-2018-18520 in elfutils,low,CVE-2018-18520
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2018-16869 in nettle,,CVE-2018-16869 in nettle,unknown,CVE-2018-16869,CWE-1
Gitlab.org,Defend,dependency_scanning,Gemnasium,detected,Regular Expression Denial of Service in debug,,Regular Expression Denial of Service in debug,unknown,CVE-2021-1234,CWE-2,"""yarn.lock:debug:gemnasium:37283ed4-0380-40d7-ada7-2d994afcc62a"""
Gitlab.org,Defend,dependency_scanning,Gemnasium,detected,Authentication bypass via incorrect DOM traversal and canonicalization in saml2-js,,Authentication bypass via incorrect DOM traversal and canonicalization in saml2-js,unknown,,,"""yarn.lock:saml2-js:gemnasium:9952e574-7b5b-46fa-a270-aeb694198a98"""
Gitlab.org,Defend,sast,Find Security Bugs,detected,Predictable pseudorandom number generator,,Predictable pseudorandom number generator,medium,,,"""818bf5dacb291e15d9e6dc3c5ac32178:PREDICTABLE_RANDOM:src/main/java/com/gitlab/security_products/tests/App.java:47"""
Gitlab.org,Defend,sast,Find Security Bugs,detected,Cipher with no integrity,,Cipher with no integrity,medium,,,"""e6449b89335daf53c0db4c0219bc1634:CIPHER_INTEGRITY:src/main/java/com/gitlab/security_products/tests/App.java:29"""
Gitlab.org,Defend,sast,Find Security Bugs,detected,Predictable pseudorandom number generator,,Predictable pseudorandom number generator,medium,,,"""e8ff1d01f74cd372f78da8f5247d3e73:PREDICTABLE_RANDOM:src/main/java/com/gitlab/security_products/tests/App.java:41"""
Gitlab.org,Defend,sast,Find Security Bugs,detected,ECB mode is insecure,,ECB mode is insecure,medium,,,"""ea0f905fc76f2739d5f10a1fd1e37a10:ECB_MODE:src/main/java/com/gitlab/security_products/tests/App.java:29"""
```
