---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Troubleshooting a GitLab installation **(FREE SELF)**

This page documents a collection of resources to help you troubleshoot a GitLab
installation.

## Troubleshooting guides

- [SSL](ssl.md)
- [Geo](../geo/replication/troubleshooting.md)
- [GitLab Rails console cheat sheet](gitlab_rails_cheat_sheet.md)
- [Example group SAML and SCIM configurations](../../user/group/saml_sso/example_saml_config.md)
- [Kubernetes cheat sheet](https://docs.gitlab.com/charts/troubleshooting/kubernetes_cheat_sheet.html)
- [Linux cheat sheet](linux_cheat_sheet.md)
- [Parsing GitLab logs with `jq`](../logs/log_parsing.md)
- [Diagnostics tools](diagnostics_tools.md)

Some feature documentation pages also have a troubleshooting section at the end
that you can check for feature-specific help.

If you need a testing environment to troubleshoot, see the
[apps for a testing environment](test_environments.md).
