# frozen_string_literal: true

class DeleteApprovalRulesForVulnerability < Gitlab::Database::Migration[2.0]
  restrict_gitlab_migration gitlab_schema: :gitlab_main
  disable_ddl_transaction!

  BATCH_SIZE = 500
  MAX_BATCH_SIZE = 1_000
  SUB_BATCH_SIZE = 10
  MIGRATION = 'DeleteApprovalRulesWithVulnerability'
  INTERVAL = 2.minutes

  def up
    return unless Gitlab.ee?

    queue_batched_background_migration(
      MIGRATION,
      :approval_project_rules,
      :id,
      job_interval: INTERVAL,
      batch_size: BATCH_SIZE,
      max_batch_size: MAX_BATCH_SIZE,
      sub_batch_size: SUB_BATCH_SIZE
    )

    queue_batched_background_migration(
      MIGRATION,
      :approval_merge_request_rules,
      :id,
      job_interval: INTERVAL,
      batch_size: BATCH_SIZE,
      max_batch_size: MAX_BATCH_SIZE,
      sub_batch_size: SUB_BATCH_SIZE
    )
  end

  def down
    # the data deleted is related to a feature removed in 15.0: https://gitlab.com/gitlab-org/gitlab/-/issues/357300
    delete_batched_background_migration(MIGRATION, :approval_project_rules, :id, [])
    delete_batched_background_migration(MIGRATION, :approval_merge_request_rules, :id, [])
  end
end
