# frozen_string_literal: true

class ScheduleMigrateSharedVulnerabilityScanners < Gitlab::Database::Migration[2.0]
  MIGRATION = "MigrateSharedVulnerabilityScanners"
  TABLE_NAME = :vulnerability_occurrences
  BATCH_COLUMN = :id
  DELAY_INTERVAL = 5.minutes
  BATCH_SIZE = 1000
  SUB_BATCH_SIZE = 100

  BATCH_MIN_VALUE = 23658505
  BATCH_MAX_VALUE = 204428752

  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_main

  def up
    queue_batched_background_migration(
      MIGRATION,
      TABLE_NAME,
      BATCH_COLUMN,
      job_interval: DELAY_INTERVAL,
      batch_size: BATCH_SIZE,
      max_batch_size: BATCH_SIZE,
      sub_batch_size: SUB_BATCH_SIZE,
      batch_min_value: BATCH_MIN_VALUE,
      batch_max_value: BATCH_MAX_VALUE
    )
  end

  def down
    delete_batched_background_migration(MIGRATION, TABLE_NAME, BATCH_COLUMN, [])
  end
end
