# frozen_string_literal: true

class IndexVulnerabilityReadsOnCastedClusterAgentIdFull < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  INDEX_NAME = 'index_vuln_reads_on_casted_cluster_agent_id_where_it_is_null'

  def up
    add_concurrent_index :vulnerability_reads,
      :casted_cluster_agent_id,
      name: INDEX_NAME,
      where: 'casted_cluster_agent_id IS NOT NULL'
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
