# frozen_string_literal: true

class RemoveVulnerabilityOccurrencesMigratedToNewStructureColumn < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_occurrences_on_migrated_to_new_structure'

  def up
    with_lock_retries do
      remove_column :vulnerability_occurrences, :migrated_to_new_structure
    end
  end

  def down
    unless column_exists?(:vulnerability_occurrences, :migrated_to_new_structure)
      add_column :vulnerability_occurrences, :migrated_to_new_structure, :boolean, default: false, null: false
    end

    add_concurrent_index :vulnerability_occurrences, [:migrated_to_new_structure, :id], name: INDEX_NAME
  end
end
