# frozen_string_literal: true

class AddIndexForVulnerabilityReadsLocationImage < Gitlab::Database::Migration[2.0]
  INDEX = :index_vulnerability_reads_on_location_image_partial

  disable_ddl_transaction!

  REPORT_TYPES = {
    container_scanning: 2,
    cluster_image_scanning: 7
  }

  QUERY = <<~SQL
    report_type in (#{REPORT_TYPES[:container_scanning]}, #{REPORT_TYPES[:cluster_image_scanning]}) AND
    location_image IS NOT NULL
  SQL

  def up
    add_concurrent_index :vulnerability_reads, [:project_id, :location_image],
      where: QUERY,
      name: INDEX
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX
  end
end
