# frozen_string_literal: true

class AddForeignKeyToVulnerabilityReadsCastedClusterAgentId < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  def up
    add_concurrent_foreign_key :vulnerability_reads, :cluster_agents,
                               column: :casted_cluster_agent_id, on_delete: :nullify
  end

  def down
    with_lock_retries do
      remove_foreign_key :vulnerability_reads, :cluster_agents, column: :casted_cluster_agent_id
    end
  end
end
