# frozen_string_literal: true

class SelfManagedRescheduleRecalculateVulnerabilityFindingSignaturesForFindings < Gitlab::Database::Migration[1.0]
  MIGRATION = 'RecalculateVulnerabilityFindingSignaturesForFindings'
  BATCH_SIZE = 1_000
  DELAY_INTERVAL = 2.minutes

  disable_ddl_transaction!

  def up
    # Only run migration for self-managed
    return if ::Gitlab.com?

    # Vulnerability Finding Signatures is an EE only feature
    return unless Gitlab.ee?

    delete_queued_jobs(MIGRATION)

    requeue_background_migration_jobs_by_range_at_intervals(
      MIGRATION,
      DELAY_INTERVAL,
      batch_size: BATCH_SIZE
    )
  end

  def down
    # no-op
  end
end
