# frozen_string_literal: true

class AddTempIndexToVulnerabilityOccurrences < Gitlab::Database::Migration[1.0]
  INDEX_NAME = 'vulnerability_occurrences_location_temp_index'

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_occurrences, :id, where: 'location IS NULL', name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_occurrences, name: INDEX_NAME
  end
end
