# frozen_string_literal: true

class AddClusterIdLocationIndexToVulnerabilityOccurrences < Gitlab::Database::Migration[1.0]
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_occurrences_on_location_cluster_id'

  def up
    add_concurrent_index :vulnerability_occurrences, "(location -> 'cluster_id')",
                         using: 'GIN',
                         where: 'report_type = 7',
                         name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_occurrences, INDEX_NAME
  end
end
