# frozen_string_literal: true

class AddIndexOnVulnerabilityOccurrencesMigratedToNewStructureColumn < Gitlab::Database::Migration[1.0]
  INDEX_NAME = 'index_vulnerability_occurrences_on_migrated_to_new_structure'

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_occurrences, [:migrated_to_new_structure, :id], name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_occurrences, INDEX_NAME
  end
end
