# frozen_string_literal: true

class CreateVulnerabilityFindingEvidenceSupportingMessages < ActiveRecord::Migration[6.1]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  disable_ddl_transaction!

  def up
    create_table_with_constraints :vulnerability_finding_evidence_supporting_messages do |t|
      t.timestamps_with_timezone null: false

      t.references :vulnerability_finding_evidence, index: { name: 'finding_evidence_supporting_messages_on_finding_evidence_id' }, null: false, foreign_key: { on_delete: :cascade }
      t.text :name

      t.text_limit :name, 2048
    end
  end

  def down
    with_lock_retries do
      drop_table :vulnerability_finding_evidence_supporting_messages
    end
  end
end
