# frozen_string_literal: true

class CreateVulnerabilityFlags < ActiveRecord::Migration[6.1]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false
  FALSE_POSITIVE_ENUM_VALUE = 0

  disable_ddl_transaction!

  def up
    create_table_with_constraints :vulnerability_flags do |t|
      t.timestamps_with_timezone null: false

      t.references :vulnerability_occurrence, null: false, foreign_key: { on_delete: :cascade }

      t.integer :flag_type, limit: 2, null: false, default: FALSE_POSITIVE_ENUM_VALUE

      t.text :origin, null: false
      t.text :description, null: false

      t.text_limit :origin, 255
      t.text_limit :description, 1024
    end
  end

  def down
    drop_table :vulnerability_flags
  end
end
