# frozen_string_literal: true

class AddIndexToVulnerabilityStatisticsOnLatestPipelineId < ActiveRecord::Migration[6.0]
  include Gitlab::Database::MigrationHelpers

  INDEX_NAME = 'index_vulnerability_statistics_on_latest_pipeline_id'

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_statistics, :latest_pipeline_id, name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_statistics, INDEX_NAME
  end
end
