# frozen_string_literal: true

class CreateVulnerabilityFindingEvidenceHeaders < ActiveRecord::Migration[6.0]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  disable_ddl_transaction!

  def up
    create_table_with_constraints :vulnerability_finding_evidence_headers do |t|
      t.timestamps_with_timezone null: false

      t.references :vulnerability_finding_evidence_request, index: { name: 'finding_evidence_header_on_finding_evidence_request_id' }, null: true, foreign_key: { on_delete: :cascade }
      t.references :vulnerability_finding_evidence_response, index: { name: 'finding_evidence_header_on_finding_evidence_response_id' }, null: true, foreign_key: { on_delete: :cascade }
      t.text :name, null: false
      t.text :value, null: false

      t.text_limit :name, 255
      t.text_limit :value, 8192
    end
  end

  def down
    with_lock_retries do
      drop_table :vulnerability_finding_evidence_headers
    end
  end
end
