# frozen_string_literal: true

class CreateVulnerabilityFindingEvidenceResponses < ActiveRecord::Migration[6.0]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  disable_ddl_transaction!

  def up
    create_table_with_constraints :vulnerability_finding_evidence_responses do |t|
      t.timestamps_with_timezone null: false

      t.references :vulnerability_finding_evidence, index: { name: 'finding_evidence_responses_on_finding_evidences_id' }, null: false, foreign_key: { on_delete: :cascade }
      t.integer :status_code
      t.text :reason_phrase

      t.text_limit :reason_phrase, 2048
    end
  end

  def down
    with_lock_retries do
      drop_table :vulnerability_finding_evidence_responses
    end
  end
end
