# frozen_string_literal: true

# Placeholder class for model that is implemented in EE
class Vulnerability < ApplicationRecord
  include EachBatch
  include IgnorableColumns

  alias_attribute :vulnerability_id, :id

  def self.link_reference_pattern
    nil
  end

  def self.reference_prefix
    '[vulnerability:'
  end

  def self.reference_postfix
    ']'
  end
end

Vulnerability.prepend_mod
