/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop;

import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Logger;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectOpenFilesHandler
implements OpenFilesHandler {
    private static final String GEPHI_EXTENSION = "gephi";

    @Override
    public void openFiles(OpenFilesEvent openFilesEvent) {
        Logger.getLogger(ProjectOpenFilesHandler.class.getName()).info("Handling " + openFilesEvent.getFiles().size() + " from opening");
        FileObject[] fileObjects = (FileObject[])openFilesEvent.getFiles().stream().filter(File::exists).map(FileUtil::toFileObject).toArray(FileObject[]::new);
        Optional<FileObject> projectFile = Arrays.stream(fileObjects).filter(f -> f.hasExt(GEPHI_EXTENSION)).findFirst();
        if (projectFile.isPresent()) {
            ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
            try {
                pc.openProject(FileUtil.toFile((FileObject)projectFile.get()));
            }
            catch (Exception ew) {
                Exceptions.printStackTrace((Throwable)ew);
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectOpenFilesHandler.class, (String)"ProjectOpenFilesHandler.openGephiError"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        } else if (fileObjects.length > 0) {
            ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
            importController.importFiles(fileObjects);
        }
    }
}

