/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.preview;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.gephi.io.exporter.preview.PNGExporter;
import org.gephi.lib.validation.ValidationClient;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class UIExporterPNGPanel
extends JPanel
implements ValidationClient {
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel labelHpx;
    private JLabel labelMargin;
    private JLabel labelMperc;
    private JLabel labelWpx;
    private JTextField marginTextField;
    private JCheckBox transparentBackgroundCheckbox;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public UIExporterPNGPanel() {
        this.initComponents();
    }

    public static ValidationPanel createValidationPanel(UIExporterPNGPanel innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        innerPanel.validate(group);
        return validationPanel;
    }

    void setup(PNGExporter exporter) {
        this.heightTextField.setText(Integer.toString(exporter.getHeight()));
        this.widthTextField.setText(Integer.toString(exporter.getWidth()));
        this.marginTextField.setText(Integer.toString(exporter.getMargin()));
        this.transparentBackgroundCheckbox.setSelected(exporter.isTransparentBackground());
    }

    void unsetup(PNGExporter exporter) {
        try {
            exporter.setWidth(Integer.parseInt(this.widthTextField.getText()));
            exporter.setHeight(Integer.parseInt(this.heightTextField.getText()));
            exporter.setMargin(Integer.parseInt(this.marginTextField.getText()));
            exporter.setTransparentBackground(this.transparentBackgroundCheckbox.isSelected());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.widthTextField = new JTextField();
        this.heightTextField = new JTextField();
        this.widthLabel = new JLabel();
        this.heightLabel = new JLabel();
        this.labelWpx = new JLabel();
        this.labelHpx = new JLabel();
        this.labelMargin = new JLabel();
        this.marginTextField = new JTextField();
        this.labelMperc = new JLabel();
        this.transparentBackgroundCheckbox = new JCheckBox();
        this.widthTextField.setName("width");
        this.heightTextField.setName("height");
        this.widthLabel.setText(NbBundle.getMessage(UIExporterPNGPanel.class, (String)"UIExporterPNGPanel.widthLabel.text"));
        this.heightLabel.setText(NbBundle.getMessage(UIExporterPNGPanel.class, (String)"UIExporterPNGPanel.heightLabel.text"));
        this.labelWpx.setText("px");
        this.labelHpx.setText("px");
        this.labelMargin.setText("Margin:");
        this.marginTextField.setName("margin");
        this.labelMperc.setText("% of width");
        this.transparentBackgroundCheckbox.setText("Transparent background");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.widthLabel).addGap(16, 16, 16).addComponent(this.widthTextField, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWpx).addGap(49, 49, 49)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.labelMargin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.marginTextField)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.heightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightTextField, -2, 87, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelMperc).addComponent(this.labelHpx)))).addComponent(this.transparentBackgroundCheckbox)).addContainerGap(123, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.widthTextField, -2, -1, -2).addComponent(this.labelWpx)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.heightLabel).addComponent(this.heightTextField, -2, -1, -2).addComponent(this.labelHpx)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelMargin).addComponent(this.marginTextField, -2, -1, -2).addComponent(this.labelMperc)).addGap(18, 18, 18).addComponent(this.transparentBackgroundCheckbox).addContainerGap(49, Short.MAX_VALUE)));
    }

    public void validate(ValidationGroup group) {
        group.add((JTextComponent)this.widthTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_INTEGER, Validators.numberRange((Number)1, (Number)Integer.MAX_VALUE)});
        group.add((JTextComponent)this.heightTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_INTEGER, Validators.numberRange((Number)1, (Number)Integer.MAX_VALUE)});
        group.add((JTextComponent)this.marginTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_INTEGER, Validators.numberRange((Number)0, (Number)100)});
    }
}

