/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.statistics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.statistics.DynamicSettingsPanel;
import org.gephi.desktop.statistics.StatisticsTopComponent;
import org.gephi.desktop.statistics.api.StatisticsControllerUI;
import org.gephi.desktop.statistics.api.StatisticsModelUI;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.statistics.api.StatisticsController;
import org.gephi.statistics.spi.DynamicStatistics;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsBuilder;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.components.SimpleHTMLReport;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.jdesktop.swingx.JXBusyLabel;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class StatisticsFrontEnd
extends JPanel {
    private final String RUN;
    private final String CANCEL;
    private final ImageIcon RUN_ICON;
    private final ImageIcon STOP_ICON;
    private StatisticsUI statisticsUI;
    private Statistics currentStatistics;
    private StatisticsModelUI currentModel;
    private JXBusyLabel busyLabel;
    private JLabel displayLabel;
    private JButton reportButton;
    private JLabel resultLabel;
    private JButton runButton;
    private JToolBar toolbar;

    public StatisticsFrontEnd(StatisticsUI ui) {
        this.initComponents();
        this.RUN = NbBundle.getMessage(StatisticsFrontEnd.class, (String)"StatisticsFrontEnd.runStatus.run");
        this.CANCEL = NbBundle.getMessage(StatisticsFrontEnd.class, (String)"StatisticsFrontEnd.runStatus.cancel");
        this.initUI(ui);
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StatisticsFrontEnd.this.runButton.getText().equals(StatisticsFrontEnd.this.RUN)) {
                    StatisticsFrontEnd.this.run();
                } else {
                    StatisticsFrontEnd.this.cancel();
                }
            }
        });
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsFrontEnd.this.showReport();
            }
        });
        this.RUN_ICON = ImageUtilities.loadImageIcon((String)"org/gephi/desktop/statistics/resources/run.png", (boolean)false);
        this.STOP_ICON = ImageUtilities.loadImageIcon((String)"org/gephi/desktop/statistics/resources/stop.png", (boolean)false);
    }

    private void initUI(StatisticsUI ui) {
        this.statisticsUI = ui;
        this.displayLabel.setText(ui.getDisplayName());
        this.displayLabel.setToolTipText(ui.getShortDescription());
        this.busyLabel.setVisible(false);
        this.runButton.setEnabled(false);
        this.runButton.setText(this.RUN);
        this.reportButton.setEnabled(false);
    }

    public void refreshModel(StatisticsModelUI model) {
        this.currentModel = model;
        if (model == null) {
            this.runButton.setText(this.RUN);
            this.runButton.setEnabled(false);
            this.busyLabel.setBusy(false);
            this.busyLabel.setVisible(false);
            this.reportButton.setEnabled(false);
            this.resultLabel.setText("");
            this.currentStatistics = null;
            return;
        }
        this.runButton.setEnabled(true);
        if (model.isRunning(this.statisticsUI)) {
            this.runButton.setText(this.CANCEL);
            this.busyLabel.setVisible(true);
            this.busyLabel.setBusy(true);
            this.reportButton.setEnabled(false);
            this.resultLabel.setText("");
            if (this.currentStatistics == null) {
                this.currentStatistics = this.currentModel.getRunning(this.statisticsUI);
            }
        } else {
            this.runButton.setText(this.RUN);
            this.busyLabel.setBusy(false);
            this.busyLabel.setVisible(false);
            this.currentStatistics = null;
            this.refreshResult(model);
        }
    }

    private void refreshResult(StatisticsModelUI model) {
        String result = model.getResult(this.statisticsUI);
        if (result != null) {
            this.resultLabel.setText(result);
        } else {
            this.resultLabel.setText("");
        }
        String report = model.getReport(this.statisticsUI.getStatisticsClass());
        this.reportButton.setEnabled(report != null);
    }

    private void run() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel();
        StatisticsController controller = (StatisticsController)Lookup.getDefault().lookup(StatisticsController.class);
        StatisticsControllerUI controllerUI = (StatisticsControllerUI)Lookup.getDefault().lookup(StatisticsControllerUI.class);
        StatisticsBuilder builder = controller.getBuilder(this.statisticsUI.getStatisticsClass());
        this.currentStatistics = builder.getStatistics();
        if (this.currentStatistics != null) {
            if (this.currentStatistics instanceof DynamicStatistics && !graphModel.isDynamic()) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(StatisticsFrontEnd.class, (String)"StatisticsFrontEnd.notDynamicGraph"), 2));
                return;
            }
            LongTaskListener listener = new LongTaskListener(){

                public void taskFinished(LongTask task) {
                    StatisticsFrontEnd.this.showReport();
                }
            };
            JPanel settingsPanel = this.statisticsUI.getSettingsPanel();
            if (this.currentStatistics instanceof DynamicStatistics) {
                DynamicSettingsPanel dynamicPanel = new DynamicSettingsPanel();
                this.statisticsUI.setup(this.currentStatistics);
                dynamicPanel.setup((DynamicStatistics)this.currentStatistics);
                JPanel dynamicSettingsPanel = DynamicSettingsPanel.createCounpoundPanel(dynamicPanel, settingsPanel);
                final DialogDescriptor dd = new DialogDescriptor((Object)dynamicSettingsPanel, NbBundle.getMessage(StatisticsTopComponent.class, (String)"StatisticsFrontEnd.settingsPanel.title", (Object)builder.getName()));
                if (dynamicSettingsPanel instanceof ValidationPanel) {
                    ValidationPanel vp = (ValidationPanel)dynamicSettingsPanel;
                    vp.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            dd.setValid(!((ValidationPanel)e.getSource()).isProblem());
                        }
                    });
                }
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(NotifyDescriptor.OK_OPTION)) {
                    dynamicPanel.unsetup((DynamicStatistics)this.currentStatistics);
                    this.statisticsUI.unsetup();
                    controllerUI.execute(this.currentStatistics, listener);
                }
            } else if (settingsPanel != null) {
                this.statisticsUI.setup(this.currentStatistics);
                final DialogDescriptor dd = new DialogDescriptor((Object)settingsPanel, NbBundle.getMessage(StatisticsTopComponent.class, (String)"StatisticsFrontEnd.settingsPanel.title", (Object)builder.getName()));
                if (settingsPanel instanceof ValidationPanel) {
                    ValidationPanel vp = (ValidationPanel)settingsPanel;
                    vp.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            dd.setValid(!((ValidationPanel)e.getSource()).isProblem());
                        }
                    });
                }
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(NotifyDescriptor.OK_OPTION)) {
                    this.statisticsUI.unsetup();
                    controllerUI.execute(this.currentStatistics, listener);
                }
            } else {
                this.statisticsUI.setup(this.currentStatistics);
                controllerUI.execute(this.currentStatistics, listener);
            }
        }
    }

    private void cancel() {
        if (this.currentStatistics != null && this.currentStatistics instanceof LongTask) {
            LongTask longTask = (LongTask)this.currentStatistics;
            longTask.cancel();
        }
    }

    private void showReport() {
        final String report = this.currentModel.getReport(this.statisticsUI.getStatisticsClass());
        if (report != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleHTMLReport dialog = new SimpleHTMLReport(WindowManager.getDefault().getMainWindow(), report);
                }
            });
        }
    }

    private void initComponents() {
        this.busyLabel = new JXBusyLabel(new Dimension(16, 16));
        this.displayLabel = new JLabel();
        this.resultLabel = new JLabel();
        this.toolbar = new JToolBar();
        this.runButton = new JButton();
        this.reportButton = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.busyLabel.setText(NbBundle.getMessage(StatisticsFrontEnd.class, (String)"StatisticsFrontEnd.busyLabel.text"));
        this.busyLabel.setMinimumSize(new Dimension(16, 16));
        this.busyLabel.setPreferredSize(new Dimension(16, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.busyLabel, gridBagConstraints);
        this.displayLabel.setText(NbBundle.getMessage(StatisticsFrontEnd.class, (String)"StatisticsFrontEnd.displayLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.displayLabel, gridBagConstraints);
        this.resultLabel.setText(NbBundle.getMessage(StatisticsFrontEnd.class, (String)"StatisticsFrontEnd.resultLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.add((Component)this.resultLabel, gridBagConstraints);
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setOpaque(false);
        this.runButton.setText(NbBundle.getMessage(StatisticsFrontEnd.class, (String)"StatisticsFrontEnd.runButton.text"));
        this.runButton.setFocusable(false);
        this.runButton.setHorizontalTextPosition(0);
        this.runButton.setMargin(new Insets(1, 2, 1, 2));
        this.runButton.setVerticalTextPosition(3);
        this.toolbar.add(this.runButton);
        this.reportButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/statistics/resources/report.png")));
        this.reportButton.setToolTipText(NbBundle.getMessage(StatisticsFrontEnd.class, (String)"StatisticsFrontEnd.reportButton.toolTipText"));
        this.reportButton.setFocusable(false);
        this.reportButton.setHorizontalTextPosition(0);
        this.reportButton.setVerticalTextPosition(3);
        this.toolbar.add(this.reportButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.toolbar, gridBagConstraints);
    }
}

