/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gephi.desktop.preview.propertyeditors.DependantColorPropertyEditor;
import org.gephi.preview.types.DependantColor;
import org.gephi.ui.components.JColorButton;
import org.jdesktop.swingx.JXHeader;
import org.openide.util.NbBundle;

public class DependantColorPanel
extends JPanel
implements ItemListener {
    private DependantColorPropertyEditor propertyEditor;
    private ButtonGroup buttonGroup1;
    private JButton colorButton;
    private JRadioButton customRadio;
    private JXHeader jXHeader1;
    private JRadioButton parentRadio;

    public DependantColorPanel() {
        this.initComponents();
        this.colorButton.addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Color newColor = (Color)evt.getNewValue();
                DependantColorPanel.this.propertyEditor.setValue(new DependantColor(newColor));
            }
        });
        this.parentRadio.addItemListener(this);
        this.customRadio.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.colorButton.setEnabled(this.customRadio.isSelected());
        DependantColor.Mode selectedMode = null;
        if (this.parentRadio.isSelected()) {
            selectedMode = DependantColor.Mode.PARENT;
        } else if (this.customRadio.isSelected()) {
            selectedMode = DependantColor.Mode.CUSTOM;
        }
        this.propertyEditor.setValue(new DependantColor(selectedMode));
    }

    public void setup(DependantColorPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        DependantColor dependantColor = (DependantColor)propertyEditor.getValue();
        if (dependantColor.getMode().equals((Object)DependantColor.Mode.CUSTOM)) {
            this.customRadio.setSelected(true);
            ((JColorButton)this.colorButton).setColor(dependantColor.getCustomColor());
        } else if (dependantColor.getMode().equals((Object)DependantColor.Mode.PARENT)) {
            this.parentRadio.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.colorButton = new JColorButton(Color.BLACK);
        this.customRadio = new JRadioButton();
        this.parentRadio = new JRadioButton();
        this.jXHeader1 = new JXHeader();
        this.buttonGroup1.add(this.customRadio);
        this.customRadio.setText(NbBundle.getMessage(DependantColorPanel.class, (String)"DependantColorPanel.customRadio.text"));
        this.buttonGroup1.add(this.parentRadio);
        this.parentRadio.setText(NbBundle.getMessage(DependantColorPanel.class, (String)"DependantColorPanel.parentRadio.text"));
        this.jXHeader1.setDescription(NbBundle.getMessage(DependantColorPanel.class, (String)"DependantColorPanel.jXHeader1.description"));
        this.jXHeader1.setTitle(NbBundle.getMessage(DependantColorPanel.class, (String)"DependantColorPanel.jXHeader1.title"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jXHeader1, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parentRadio).addGroup(layout.createSequentialGroup().addComponent(this.customRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorButton))).addGap(221, 221, 221)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jXHeader1, -2, 77, -2).addGap(18, 18, 18).addComponent(this.parentRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customRadio).addComponent(this.colorButton)).addContainerGap(43, Short.MAX_VALUE)));
    }
}

