/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.api.Interpolator;
import org.gephi.appearance.api.RankingFunction;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceToolbar;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.desktop.appearance.AppearanceUIModel;
import org.gephi.desktop.appearance.AppearanceUIModelEvent;
import org.gephi.desktop.appearance.AppearanceUIModelListener;
import org.gephi.desktop.appearance.AutoAppyTransformer;
import org.gephi.ui.components.splineeditor.SplineEditor;
import org.gephi.ui.utils.UIUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="AppearanceTopComponent", iconBase="org/gephi/desktop/appearance/resources/small.png", persistenceType=0)
public class AppearanceTopComponent
extends TopComponent
implements Lookup.Provider,
AppearanceUIModelListener {
    private final String NO_SELECTION = NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.choose.text");
    private final transient AppearanceToolbar toolbar;
    private final transient AppearanceUIController controller;
    private transient JPanel transformerPanel;
    private transient JToggleButton listButton;
    private transient ItemListener attributeListener;
    private transient SplineEditor splineEditor;
    private transient AppearanceUIModel model;
    private JButton applyButton;
    private JComboBox attibuteBox;
    private JPanel attributePanel;
    private JToggleButton autoApplyButton;
    private JToolBar autoApplyToolbar;
    private JToolBar categoryToolbar;
    private JPanel centerPanel;
    private JPanel controlPanel;
    private JToolBar controlToolbar;
    private JToggleButton enableAutoButton;
    private JToggleButton rankingLocalScaleButton;
    private JToggleButton partitionLocalScaleButton;
    private JToggleButton transformNullValuesButton;
    private JPanel mainPanel;
    private JXHyperlink splineButton;
    private JToggleButton stopAutoApplyButton;
    private JToolBar tranformerToolbar;

    public AppearanceTopComponent() {
        this.setName(NbBundle.getMessage(AppearanceTopComponent.class, (String)"CTL_AppearanceTopComponent"));
        this.controller = (AppearanceUIController)Lookup.getDefault().lookup(AppearanceUIController.class);
        this.model = this.controller.getModel();
        this.controller.addPropertyChangeListener(this);
        this.toolbar = new AppearanceToolbar(this.controller);
        this.initComponents();
        this.initControls();
        if (UIUtils.isAquaLookAndFeel()) {
            this.mainPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.centerPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.refreshModel(this.model);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals(AppearanceUIModelEvent.MODEL)) {
            this.refreshModel((AppearanceUIModel)pce.getNewValue());
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SELECTED_CATEGORY) || pce.getPropertyName().equals(AppearanceUIModelEvent.SELECTED_ELEMENT_CLASS) || pce.getPropertyName().equals(AppearanceUIModelEvent.SELECTED_TRANSFORMER_UI)) {
            this.refreshCenterPanel();
            this.refreshCombo();
            this.refreshControls();
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SELECTED_FUNCTION)) {
            this.refreshCenterPanel();
            this.refreshCombo();
            this.refreshControls();
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SET_AUTO_APPLY)) {
            this.refreshControls();
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.START_STOP_AUTO_APPLY)) {
            this.refreshControls();
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SET_LOCAL_SCALE)) {
            this.refreshControls();
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.ATTRIBUTE_LIST)) {
            this.refreshCombo();
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.REFRESH_FUNCTION)) {
            this.refreshCenterPanel();
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SET_TRANSFORM_NULL_VALUES)) {
            this.refreshControls();
            this.refreshCenterPanel();
        }
    }

    public void refreshModel(AppearanceUIModel model) {
        this.model = model;
        this.refreshEnable();
        this.refreshCenterPanel();
        this.refreshCombo();
        this.refreshControls();
    }

    private void refreshCenterPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TransformerUI ui;
                if (AppearanceTopComponent.this.transformerPanel != null) {
                    AppearanceTopComponent.this.centerPanel.remove(AppearanceTopComponent.this.transformerPanel);
                    AppearanceTopComponent.this.transformerPanel = null;
                }
                if (AppearanceTopComponent.this.model != null && (ui = AppearanceTopComponent.this.model.getSelectedTransformerUI()) != null) {
                    boolean attribute = AppearanceTopComponent.this.model.isAttributeTransformerUI(ui);
                    AppearanceTopComponent.this.attributePanel.setVisible(attribute);
                    if (attribute) {
                        Function function = AppearanceTopComponent.this.model.getSelectedFunction();
                        if (function != null) {
                            ui = function.getUI();
                            AppearanceTopComponent.this.transformerPanel = ui.getPanel(function);
                        }
                    } else {
                        Function function = AppearanceTopComponent.this.model.getSelectedFunction();
                        AppearanceTopComponent.this.transformerPanel = ui.getPanel(function);
                    }
                    if (AppearanceTopComponent.this.transformerPanel != null) {
                        AppearanceTopComponent.this.transformerPanel.setOpaque(true);
                        AppearanceTopComponent.this.centerPanel.add((Component)AppearanceTopComponent.this.transformerPanel, "Center");
                    }
                    AppearanceTopComponent.this.centerPanel.revalidate();
                    AppearanceTopComponent.this.centerPanel.repaint();
                    return;
                }
                AppearanceTopComponent.this.attributePanel.setVisible(false);
            }
        });
    }

    private void refreshCombo() {
        if (this.model != null && this.model.getSelectedTransformerUI() != null && this.model.isAttributeTransformerUI(this.model.getSelectedTransformerUI())) {
            ArrayList<Function> rows = new ArrayList<Function>(this.model.getFunctions());
            Collections.sort(rows, (o1, o2) -> {
                if (o1.isAttribute() && !o2.isAttribute()) {
                    return 1;
                }
                if (!o1.isAttribute() && o2.isAttribute()) {
                    return -1;
                }
                return o1.toString().compareTo(o2.toString());
            });
            SwingUtilities.invokeLater(() -> {
                DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
                Function selectedColumn = this.model.getSelectedFunction();
                this.attibuteBox.removeItemListener(this.attributeListener);
                comboBoxModel.addElement(this.NO_SELECTION);
                comboBoxModel.setSelectedItem(this.NO_SELECTION);
                for (Function r : rows) {
                    comboBoxModel.addElement((String)r);
                    if (selectedColumn == null || !selectedColumn.equals(r)) continue;
                    comboBoxModel.setSelectedItem(r);
                }
                this.attributeListener = new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (AppearanceTopComponent.this.model != null) {
                            if (!AppearanceTopComponent.this.attibuteBox.getSelectedItem().equals(AppearanceTopComponent.this.NO_SELECTION)) {
                                Function selectedItem = (Function)AppearanceTopComponent.this.attibuteBox.getSelectedItem();
                                Function selectedFunction = AppearanceTopComponent.this.model.getSelectedFunction();
                                if (selectedFunction != selectedItem) {
                                    AppearanceTopComponent.this.controller.setSelectedFunction(selectedItem);
                                }
                            } else {
                                AppearanceTopComponent.this.controller.setSelectedFunction(null);
                            }
                        }
                    }
                };
                this.attibuteBox.addItemListener(this.attributeListener);
                this.attibuteBox.setModel(comboBoxModel);
            });
        } else {
            SwingUtilities.invokeLater(() -> this.attibuteBox.setModel(new DefaultComboBoxModel()));
        }
    }

    private void refreshControls() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AppearanceTopComponent.this.model != null && AppearanceTopComponent.this.model.getSelectedFunction() != null) {
                    AppearanceTopComponent.this.enableAutoButton.setEnabled(true);
                    if (AppearanceTopComponent.this.model.getAutoApplyTransformer() != null) {
                        AppearanceTopComponent.this.applyButton.setVisible(false);
                        AppearanceTopComponent.this.enableAutoButton.setSelected(true);
                        AutoAppyTransformer aat = AppearanceTopComponent.this.model.getAutoApplyTransformer();
                        if (aat.isRunning()) {
                            AppearanceTopComponent.this.autoApplyButton.setVisible(false);
                            AppearanceTopComponent.this.stopAutoApplyButton.setVisible(true);
                            AppearanceTopComponent.this.stopAutoApplyButton.setSelected(true);
                        } else {
                            AppearanceTopComponent.this.autoApplyButton.setVisible(true);
                            AppearanceTopComponent.this.autoApplyButton.setSelected(false);
                            AppearanceTopComponent.this.stopAutoApplyButton.setVisible(false);
                        }
                    } else {
                        AppearanceTopComponent.this.autoApplyButton.setVisible(false);
                        AppearanceTopComponent.this.stopAutoApplyButton.setVisible(false);
                        AppearanceTopComponent.this.enableAutoButton.setSelected(false);
                        AppearanceTopComponent.this.applyButton.setVisible(true);
                        AppearanceTopComponent.this.applyButton.setEnabled(true);
                    }
                    AppearanceTopComponent.this.rankingLocalScaleButton.setSelected(AppearanceTopComponent.this.model.isRankingLocalScale());
                    AppearanceTopComponent.this.partitionLocalScaleButton.setSelected(AppearanceTopComponent.this.model.isPartitionLocalScale());
                    AppearanceTopComponent.this.transformNullValuesButton.setSelected(AppearanceTopComponent.this.model.isTransformNullValues());
                    return;
                }
                AppearanceTopComponent.this.stopAutoApplyButton.setVisible(false);
                AppearanceTopComponent.this.autoApplyButton.setVisible(false);
                AppearanceTopComponent.this.applyButton.setVisible(true);
                AppearanceTopComponent.this.applyButton.setEnabled(false);
                AppearanceTopComponent.this.enableAutoButton.setEnabled(false);
            }
        });
    }

    private void initControls() {
        this.toolbar.addRankingControl((AbstractButton)this.splineButton);
        this.toolbar.addRankingControl(this.rankingLocalScaleButton);
        this.toolbar.addRankingControl(this.transformNullValuesButton);
        this.toolbar.addPartitionControl(this.partitionLocalScaleButton);
        this.toolbar.addPartitionControl(this.transformNullValuesButton);
        this.rankingLocalScaleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppearanceTopComponent.this.controller.getAppearanceController().setUseRankingLocalScale(AppearanceTopComponent.this.rankingLocalScaleButton.isSelected());
            }
        });
        this.partitionLocalScaleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppearanceTopComponent.this.controller.getAppearanceController().setUsePartitionLocalScale(AppearanceTopComponent.this.partitionLocalScaleButton.isSelected());
            }
        });
        this.transformNullValuesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppearanceTopComponent.this.controller.getAppearanceController().setTransformNullValues(AppearanceTopComponent.this.transformNullValuesButton.isSelected());
            }
        });
        this.splineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interpolator interpolator;
                RankingFunction function = (RankingFunction)AppearanceTopComponent.this.model.getSelectedFunction();
                if (AppearanceTopComponent.this.splineEditor == null) {
                    AppearanceTopComponent.this.splineEditor = new SplineEditor(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.splineEditor.title"));
                }
                if ((interpolator = function.getInterpolator()) instanceof Interpolator.BezierInterpolator) {
                    Interpolator.BezierInterpolator bezierInterpolator = (Interpolator.BezierInterpolator)interpolator;
                    AppearanceTopComponent.this.splineEditor.setControl1(bezierInterpolator.getControl1());
                    AppearanceTopComponent.this.splineEditor.setControl2(bezierInterpolator.getControl2());
                } else {
                    AppearanceTopComponent.this.splineEditor.setControl1((Point2D)new Point2D.Float(0.0f, 0.0f));
                    AppearanceTopComponent.this.splineEditor.setControl2((Point2D)new Point2D.Float(1.0f, 1.0f));
                }
                AppearanceTopComponent.this.splineEditor.setVisible(true);
                function.setInterpolator((Interpolator)new Interpolator.BezierInterpolator((float)AppearanceTopComponent.this.splineEditor.getControl1().getX(), (float)AppearanceTopComponent.this.splineEditor.getControl1().getY(), (float)AppearanceTopComponent.this.splineEditor.getControl2().getX(), (float)AppearanceTopComponent.this.splineEditor.getControl2().getY()));
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppearanceTopComponent.this.controller.transform(AppearanceTopComponent.this.model.getSelectedFunction());
            }
        });
        this.autoApplyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppearanceTopComponent.this.controller.startAutoApply();
            }
        });
        this.stopAutoApplyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppearanceTopComponent.this.controller.stopAutoApply();
            }
        });
        this.enableAutoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppearanceTopComponent.this.controller.setAutoApply(AppearanceTopComponent.this.model.getAutoApplyTransformer() == null);
            }
        });
        this.stopAutoApplyButton.setVisible(false);
        this.autoApplyButton.setVisible(false);
    }

    private void refreshEnable() {
        boolean modelEnabled = this.isModelEnabled();
    }

    private boolean isModelEnabled() {
        return this.model != null;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.categoryToolbar = this.toolbar.getCategoryToolbar();
        this.tranformerToolbar = this.toolbar.getTransformerToolbar();
        this.attributePanel = new JPanel();
        this.attibuteBox = new JComboBox();
        this.centerPanel = new JPanel();
        this.controlToolbar = this.toolbar.getControlToolbar();
        this.rankingLocalScaleButton = new JToggleButton();
        this.partitionLocalScaleButton = new JToggleButton();
        this.transformNullValuesButton = new JToggleButton();
        this.splineButton = new JXHyperlink();
        this.controlPanel = new JPanel();
        this.applyButton = new JButton();
        this.stopAutoApplyButton = new JToggleButton();
        this.autoApplyToolbar = new JToolBar();
        this.enableAutoButton = new JToggleButton();
        this.autoApplyButton = new JToggleButton();
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setOpaque(true);
        this.categoryToolbar.setFloatable(false);
        this.categoryToolbar.setRollover(true);
        this.categoryToolbar.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.categoryToolbar, gridBagConstraints);
        this.tranformerToolbar.setFloatable(false);
        this.tranformerToolbar.setRollover(true);
        this.tranformerToolbar.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.tranformerToolbar, gridBagConstraints);
        this.attributePanel.setOpaque(true);
        this.attributePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.attributePanel.add((Component)this.attibuteBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.attributePanel, gridBagConstraints);
        this.centerPanel.setOpaque(true);
        this.centerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.centerPanel, gridBagConstraints);
        this.controlToolbar.setFloatable(false);
        this.controlToolbar.setRollover(true);
        this.controlToolbar.setMargin(new Insets(0, 4, 0, 0));
        this.controlToolbar.setOpaque(true);
        this.rankingLocalScaleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/funnel.png")));
        this.rankingLocalScaleButton.setToolTipText(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.localScaleButton.toolTipText"));
        this.rankingLocalScaleButton.setFocusable(false);
        this.rankingLocalScaleButton.setSelectedIcon(new ImageIcon(UIUtils.generateSelectedDarkImage((Image)new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/funnel.png")).getImage())));
        this.controlToolbar.add(this.rankingLocalScaleButton);
        this.partitionLocalScaleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/funnel.png")));
        this.partitionLocalScaleButton.setToolTipText(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.partitionLocalScaleButton.toolTipText"));
        this.partitionLocalScaleButton.setFocusable(false);
        this.partitionLocalScaleButton.setSelectedIcon(new ImageIcon(UIUtils.generateSelectedDarkImage((Image)new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/funnel.png")).getImage())));
        this.controlToolbar.add(this.partitionLocalScaleButton);
        this.transformNullValuesButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/transformNull.png")));
        this.transformNullValuesButton.setToolTipText(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.transformNullValues.toolTipText"));
        this.transformNullValuesButton.setFocusable(false);
        this.transformNullValuesButton.setSelectedIcon(new ImageIcon(UIUtils.generateSelectedDarkImage((Image)new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/transformNull.png")).getImage())));
        this.controlToolbar.add(this.transformNullValuesButton);
        Mnemonics.setLocalizedText((AbstractButton)this.splineButton, (String)NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.splineButton.text"));
        this.splineButton.setToolTipText(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.splineButton.toolTipText"));
        this.splineButton.setClickedColor(new Color(0, 51, 255));
        this.splineButton.setFocusPainted(false);
        this.splineButton.setFocusable(false);
        this.splineButton.setHorizontalAlignment(2);
        this.splineButton.setHorizontalTextPosition(0);
        this.controlToolbar.add((Component)this.splineButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.mainPanel.add((Component)this.controlToolbar, gridBagConstraints);
        this.controlPanel.setOpaque(true);
        this.controlPanel.setLayout(new GridBagLayout());
        this.applyButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/apply.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.applyButton, (String)NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.applyButton.text"));
        this.applyButton.setToolTipText(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.applyButton.toolTipText"));
        this.applyButton.setMargin(new Insets(0, 14, 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 18, 3, 5);
        this.controlPanel.add((Component)this.applyButton, gridBagConstraints);
        this.stopAutoApplyButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/stop.png")));
        this.stopAutoApplyButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.stopAutoApplyButton, (String)NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.stopAutoApplyButton.text"));
        this.stopAutoApplyButton.setToolTipText(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.stopAutoApplyButton.toolTipText"));
        this.stopAutoApplyButton.setFocusable(false);
        this.stopAutoApplyButton.setHorizontalTextPosition(4);
        this.stopAutoApplyButton.setMargin(new Insets(0, 7, 0, 7));
        this.stopAutoApplyButton.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 3, 3, 5);
        this.controlPanel.add((Component)this.stopAutoApplyButton, gridBagConstraints);
        this.autoApplyToolbar.setFloatable(false);
        this.autoApplyToolbar.setRollover(true);
        this.autoApplyToolbar.setOpaque(true);
        this.enableAutoButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/chain.png")));
        this.enableAutoButton.setToolTipText(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.enableAutoButton.toolTipText"));
        this.enableAutoButton.setFocusable(false);
        this.enableAutoButton.setHorizontalTextPosition(0);
        this.enableAutoButton.setVerticalTextPosition(3);
        this.autoApplyToolbar.add(Box.createHorizontalGlue());
        this.autoApplyToolbar.add(this.enableAutoButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.controlPanel.add((Component)this.autoApplyToolbar, gridBagConstraints);
        this.autoApplyButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/appearance/resources/apply.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.autoApplyButton, (String)NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.autoApplyButton.text"));
        this.autoApplyButton.setToolTipText(NbBundle.getMessage(AppearanceTopComponent.class, (String)"AppearanceTopComponent.autoApplyButton.toolTipText"));
        this.autoApplyButton.setFocusable(false);
        this.autoApplyButton.setHorizontalTextPosition(4);
        this.autoApplyButton.setMargin(new Insets(0, 7, 0, 7));
        this.autoApplyButton.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 3, 3, 5);
        this.controlPanel.add((Component)this.autoApplyButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.controlPanel, gridBagConstraints);
        this.add(this.mainPanel, "Center");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

